/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.tenant;

import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.tenant.ITenantIdentificationStrategy;
import ca.uhn.fhir.util.UrlPathTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlBaseTenantIdentificationStrategy
implements ITenantIdentificationStrategy {
    private static final Logger ourLog = LoggerFactory.getLogger(UrlBaseTenantIdentificationStrategy.class);

    @Override
    public void extractTenant(UrlPathTokenizer theUrlPathTokenizer, RequestDetails theRequestDetails) {
        String tenantId = null;
        boolean isSystemRequest = theRequestDetails instanceof SystemRequestDetails;
        if (!theUrlPathTokenizer.hasMoreTokens()) {
            if (isSystemRequest) {
                tenantId = "DEFAULT";
                theRequestDetails.setTenantId(tenantId);
                ourLog.trace("No tenant ID found for system request; using DEFAULT.");
            }
        } else {
            tenantId = (String)StringUtils.defaultIfBlank((CharSequence)theUrlPathTokenizer.peek(), null);
            if (tenantId != null && (tenantId.equals("metadata") || this.isOperation(tenantId))) {
                tenantId = "DEFAULT";
                theRequestDetails.setTenantId(tenantId);
                ourLog.trace("No tenant ID found for metadata or system request; using DEFAULT.");
            } else {
                tenantId = (String)StringUtils.defaultIfBlank((CharSequence)theUrlPathTokenizer.nextTokenUnescapedAndSanitized(), null);
                if (tenantId != null) {
                    theRequestDetails.setTenantId(tenantId);
                    ourLog.trace("Found tenant ID {} in request string", (Object)tenantId);
                }
            }
        }
        if (tenantId == null) {
            HapiLocalizer localizer = theRequestDetails.getServer().getFhirContext().getLocalizer();
            throw new InvalidRequestException(Msg.code((int)307) + localizer.getMessage(RestfulServer.class, "rootRequest.multitenant", new Object[0]));
        }
    }

    private boolean isOperation(String theToken) {
        return theToken.startsWith("$");
    }

    @Override
    public String massageServerBaseUrl(String theFhirServerBase, RequestDetails theRequestDetails) {
        Object result = theFhirServerBase;
        if (theRequestDetails.getTenantId() != null) {
            result = (String)result + "/" + theRequestDetails.getTenantId();
        }
        return result;
    }

    @Override
    public String resolveRelativeUrl(String theRelativeUrl, RequestDetails theRequestDetails) {
        UrlPathTokenizer tokenizer = new UrlPathTokenizer(theRelativeUrl);
        if (!tokenizer.hasMoreTokens() || tokenizer.peek() == null) {
            return theRelativeUrl;
        }
        String nextToken = tokenizer.peek();
        if (theRequestDetails.getTenantId() == null || nextToken.equals(theRequestDetails.getTenantId())) {
            return theRelativeUrl;
        }
        if (this.isResourceType(nextToken, theRequestDetails) || this.isOperation(nextToken)) {
            return theRequestDetails.getTenantId() + "/" + theRelativeUrl;
        }
        return theRelativeUrl;
    }

    private boolean isResourceType(String token, RequestDetails theRequestDetails) {
        return theRequestDetails.getFhirContext().getResourceTypes().stream().anyMatch(type -> type.equals(token));
    }
}

