/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.servlet;

import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServletSubRequestDetails
extends ServletRequestDetails {
    private final ServletRequestDetails myWrap;
    private Map<String, List<String>> myHeaders = new HashMap<String, List<String>>();

    public ServletSubRequestDetails(ServletRequestDetails theRequestDetails) {
        super(theRequestDetails.getInterceptorBroadcaster());
        this.myWrap = theRequestDetails;
        if (theRequestDetails != null) {
            Map<String, List<String>> headers = theRequestDetails.getHeaders();
            for (Map.Entry<String, List<String>> next : headers.entrySet()) {
                this.myHeaders.put(next.getKey().toLowerCase(), next.getValue());
            }
        }
    }

    @Override
    public HttpServletRequest getServletRequest() {
        return this.myWrap.getServletRequest();
    }

    @Override
    public HttpServletResponse getServletResponse() {
        return this.myWrap.getServletResponse();
    }

    public void addHeader(String theName, String theValue) {
        String lowerCase = theName.toLowerCase();
        List list = this.myHeaders.computeIfAbsent(lowerCase, k -> new ArrayList());
        list.add(theValue);
    }

    @Override
    public String getHeader(String theName) {
        List<String> list = this.myHeaders.get(theName.toLowerCase());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<String> getHeaders(String theName) {
        List<String> list = this.myHeaders.get(theName.toLowerCase());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public Map<Object, Object> getUserData() {
        return this.myWrap.getUserData();
    }

    @Override
    public boolean isSubRequest() {
        return true;
    }
}

