/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.ResponsePage;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ValidateUtil;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashMapResourceProvider<T extends IBaseResource>
implements IResourceProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(HashMapResourceProvider.class);
    private final Class<T> myResourceType;
    private final FhirContext myFhirContext;
    private final String myResourceName;
    private final AtomicLong myDeleteCount = new AtomicLong(0L);
    private final AtomicLong myUpdateCount = new AtomicLong(0L);
    private final AtomicLong myCreateCount = new AtomicLong(0L);
    private final AtomicLong myReadCount = new AtomicLong(0L);
    protected Map<String, TreeMap<Long, T>> myIdToVersionToResourceMap = new LinkedHashMap<String, TreeMap<Long, T>>();
    protected Map<String, LinkedList<T>> myIdToHistory = new LinkedHashMap<String, LinkedList<T>>();
    protected LinkedList<T> myTypeHistory = new LinkedList();
    protected AtomicLong mySearchCount = new AtomicLong(0L);
    private long myNextId;

    public HashMapResourceProvider(FhirContext theFhirContext, Class<T> theResourceType) {
        this.myFhirContext = theFhirContext;
        this.myResourceType = theResourceType;
        this.myResourceName = this.myFhirContext.getResourceType(theResourceType);
        this.clear();
    }

    public synchronized void clear() {
        this.myNextId = 1L;
        this.myIdToVersionToResourceMap.clear();
        this.myIdToHistory.clear();
        this.myTypeHistory.clear();
    }

    public synchronized void clearCounts() {
        this.myReadCount.set(0L);
        this.myUpdateCount.set(0L);
        this.myCreateCount.set(0L);
        this.myDeleteCount.set(0L);
        this.mySearchCount.set(0L);
    }

    @Create
    public synchronized MethodOutcome create(@ResourceParam T theResource, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        this.createInternal(theResource, theRequestDetails, transactionDetails);
        this.myCreateCount.incrementAndGet();
        return new MethodOutcome().setCreated(Boolean.valueOf(true)).setResource(theResource).setId(theResource.getIdElement());
    }

    private void createInternal(@ResourceParam T theResource, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        long idPart = this.myNextId++;
        String idPartAsString = Long.toString(idPart);
        Long versionIdPart = 1L;
        assert (!this.myIdToVersionToResourceMap.containsKey(idPartAsString));
        this.store(theResource, idPartAsString, versionIdPart, theRequestDetails, theTransactionDetails, false);
    }

    @Delete
    public synchronized MethodOutcome delete(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        TreeMap<Long, T> versions = this.myIdToVersionToResourceMap.get(theId.getIdPart());
        if (versions == null || versions.isEmpty()) {
            throw new ResourceNotFoundException(Msg.code((int)2250) + theId);
        }
        IBaseResource deletedInstance = (IBaseResource)this.myFhirContext.getResourceDefinition(this.myResourceType).newInstance();
        long nextVersion = versions.lastEntry().getKey() + 1L;
        IIdType id = this.store(deletedInstance, theId.getIdPart(), nextVersion, theRequestDetails, transactionDetails, true);
        this.myDeleteCount.incrementAndGet();
        return new MethodOutcome().setId(id);
    }

    public synchronized long getCountCreate() {
        return this.myCreateCount.get();
    }

    public synchronized long getCountDelete() {
        return this.myDeleteCount.get();
    }

    public synchronized long getCountRead() {
        return this.myReadCount.get();
    }

    public synchronized long getCountSearch() {
        return this.mySearchCount.get();
    }

    public synchronized long getCountUpdate() {
        return this.myUpdateCount.get();
    }

    public Class<T> getResourceType() {
        return this.myResourceType;
    }

    private TreeMap<Long, T> getVersionToResource(String theIdPart) {
        this.myIdToVersionToResourceMap.computeIfAbsent(theIdPart, t -> new TreeMap());
        return this.myIdToVersionToResourceMap.get(theIdPart);
    }

    @History
    public synchronized List<IBaseResource> historyInstance(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        LinkedList<T> retVal = this.myIdToHistory.get(theId.getIdPart());
        if (retVal == null) {
            throw new ResourceNotFoundException(Msg.code((int)2248) + theId);
        }
        return HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(retVal, theRequestDetails);
    }

    @History
    public List<T> historyType() {
        return this.myTypeHistory;
    }

    @Read(version=true)
    public T read(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        return this.read(theId, theRequestDetails, false);
    }

    public synchronized T read(IIdType theId, RequestDetails theRequestDetails, boolean theDeletedOk) {
        IBaseResource retVal;
        TreeMap<Long, T> versions = this.myIdToVersionToResourceMap.get(theId.getIdPart());
        if (versions == null || versions.isEmpty()) {
            throw new ResourceNotFoundException(Msg.code((int)2247) + theId);
        }
        if (theId.hasVersionIdPart()) {
            Long versionId = theId.getVersionIdPartAsLong();
            if (!versions.containsKey(versionId)) {
                throw new ResourceNotFoundException(Msg.code((int)1982) + theId);
            }
            retVal = (IBaseResource)versions.get(versionId);
        } else {
            retVal = (IBaseResource)versions.lastEntry().getValue();
        }
        if ((retVal == null || retVal.isDeleted()) && !theDeletedOk) {
            throw new ResourceGoneException(Msg.code((int)2244) + theId);
        }
        this.myReadCount.incrementAndGet();
        retVal = HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(retVal, theRequestDetails);
        if (retVal == null) {
            throw new ResourceNotFoundException(Msg.code((int)2243) + theId);
        }
        return (T)retVal;
    }

    @Search(allowUnknownParams=true)
    public synchronized IBundleProvider searchAll(final RequestDetails theRequestDetails) {
        this.mySearchCount.incrementAndGet();
        final List<T> allResources = this.getAllResources();
        if (theRequestDetails.getParameters().containsKey("_id")) {
            for (String nextParam : theRequestDetails.getParameters().get("_id")) {
                List wantIds = Arrays.stream(nextParam.split(",")).map(StringUtils::trim).filter(StringUtils::isNotBlank).map(IdDt::new).collect(Collectors.toList());
                Iterator<T> iter = allResources.iterator();
                while (iter.hasNext()) {
                    IBaseResource next = (IBaseResource)iter.next();
                    boolean found = wantIds.stream().anyMatch(t -> this.resourceIdMatches((T)next, (IdDt)t));
                    if (found) continue;
                    iter.remove();
                }
            }
        }
        return new SimpleBundleProvider(allResources){

            @Override
            @Nonnull
            public List<IBaseResource> getResources(int theFromIndex, int theToIndex, @Nonnull ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
                int from = Math.max(0, theFromIndex);
                int to = Math.min(theToIndex, allResources.size());
                to = Math.max(from, to);
                List<IBaseResource> retVal = allResources.subList(from, to);
                retVal = HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(retVal, theRequestDetails);
                return retVal;
            }
        };
    }

    @Nonnull
    protected synchronized List<T> getAllResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (TreeMap<Long, T> next : this.myIdToVersionToResourceMap.values()) {
            IBaseResource nextResource;
            if (next.isEmpty() || (nextResource = (IBaseResource)next.lastEntry().getValue()) == null || nextResource.isDeleted()) continue;
            IBaseResource nextResourceClone = this.myFhirContext.newTerser().clone(nextResource);
            retVal.add(nextResourceClone);
        }
        return retVal;
    }

    private IIdType store(@Nonnull T theResource, String theIdPart, Long theVersionIdPart, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, boolean theDeleted) {
        IIdType id = this.myFhirContext.getVersion().newIdType();
        String versionIdPart = Long.toString(theVersionIdPart);
        id.setParts(null, this.myResourceName, theIdPart, versionIdPart);
        theResource.setId(id);
        if (theDeleted) {
            IPrimitiveType deletedAt = (IPrimitiveType)this.myFhirContext.getElementDefinition("instant").newInstance();
            deletedAt.setValue((Object)new Date());
            ResourceMetadataKeyEnum.DELETED_AT.put(theResource, (Object)deletedAt);
            ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(theResource, (Object)BundleEntryTransactionMethodEnum.DELETE);
        } else {
            ResourceMetadataKeyEnum.DELETED_AT.put(theResource, null);
            if (theVersionIdPart > 1L) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(theResource, (Object)BundleEntryTransactionMethodEnum.PUT);
            } else {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(theResource, (Object)BundleEntryTransactionMethodEnum.POST);
            }
        }
        if (this.myFhirContext.getVersion().getVersion() == FhirVersionEnum.DSTU2) {
            ResourceMetadataKeyEnum.VERSION.put(theResource, (Object)versionIdPart);
        } else {
            BaseRuntimeChildDefinition metaChild = this.myFhirContext.getResourceDefinition(this.myResourceType).getChildByName("meta");
            List metaValues = metaChild.getAccessor().getValues(theResource);
            if (metaValues.size() > 0) {
                theResource.getMeta().setVersionId(versionIdPart);
            }
        }
        ourLog.info("Storing resource with ID: {}", (Object)id.getValue());
        if (theRequestDetails != null && theRequestDetails.getInterceptorBroadcaster() != null) {
            HookParams preStorageParams;
            IInterceptorBroadcaster interceptorBroadcaster = theRequestDetails.getInterceptorBroadcaster();
            if (theDeleted) {
                preStorageParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, (Object)((IBaseResource)this.myIdToHistory.get(theIdPart).getFirst())).add(TransactionDetails.class, (Object)theTransactionDetails);
                interceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_RESOURCE_DELETED, preStorageParams);
                HookParams preCommitParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, (Object)((IBaseResource)this.myIdToHistory.get(theIdPart).getFirst())).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED));
                interceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED, preCommitParams);
            } else if (!this.myIdToHistory.containsKey(theIdPart)) {
                preStorageParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, theResource).add(RequestPartitionId.class, null).add(TransactionDetails.class, (Object)theTransactionDetails);
                interceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED, preStorageParams);
                HookParams preCommitParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, theResource).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED));
                interceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED, preCommitParams);
            } else {
                preStorageParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, (Object)((IBaseResource)this.myIdToHistory.get(theIdPart).getFirst())).add(IBaseResource.class, theResource).add(TransactionDetails.class, (Object)theTransactionDetails);
                interceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED, preStorageParams);
                HookParams preCommitParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, (Object)((IBaseResource)this.myIdToHistory.get(theIdPart).getFirst())).add(IBaseResource.class, theResource).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED));
                interceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED, preCommitParams);
            }
        }
        TreeMap<Long, T> versionToResource = this.getVersionToResource(theIdPart);
        versionToResource.put(theVersionIdPart, theResource);
        this.myTypeHistory.addFirst(theResource);
        this.myIdToHistory.computeIfAbsent(theIdPart, t -> new LinkedList());
        this.myIdToHistory.get(theIdPart).addFirst(theResource);
        return id;
    }

    @Update
    public synchronized MethodOutcome update(@ResourceParam T theResource, @ConditionalUrlParam String theConditional, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        ValidateUtil.isTrueOrThrowInvalidRequest((boolean)StringUtils.isBlank((CharSequence)theConditional), (String)"This server doesn't support conditional update", (Object[])new Object[0]);
        boolean created = this.updateInternal(theResource, theRequestDetails, transactionDetails);
        this.myUpdateCount.incrementAndGet();
        return new MethodOutcome().setCreated(Boolean.valueOf(created)).setResource(theResource).setId(theResource.getIdElement());
    }

    private boolean updateInternal(@ResourceParam T theResource, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        boolean created;
        Long versionIdPart;
        String idPartAsString = theResource.getIdElement().getIdPart();
        TreeMap<Long, T> versionToResource = this.getVersionToResource(idPartAsString);
        if (versionToResource.isEmpty()) {
            versionIdPart = 1L;
            created = true;
        } else {
            versionIdPart = versionToResource.lastKey() + 1L;
            created = false;
        }
        IIdType id = this.store(theResource, idPartAsString, versionIdPart, theRequestDetails, theTransactionDetails, false);
        theResource.setId(id);
        return created;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public synchronized IIdType store(T theResource) {
        if (theResource.getIdElement().hasIdPart()) {
            this.updateInternal(theResource, null, new TransactionDetails());
        } else {
            this.createInternal(theResource, null, new TransactionDetails());
        }
        return theResource.getIdElement();
    }

    public synchronized List<T> getStoredResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (TreeMap<Long, T> next : this.myIdToVersionToResourceMap.values()) {
            retVal.add((IBaseResource)next.lastEntry().getValue());
        }
        return Collections.unmodifiableList(retVal);
    }

    private boolean resourceIdMatches(T theResource, IdDt theId) {
        return (theId.getResourceType() == null || theId.getResourceType().equals(this.myFhirContext.getResourceType(theResource))) && theResource.getIdElement().getIdPart().equals(theId.getIdPart());
    }

    private static <T extends IBaseResource> T fireInterceptorsAndFilterAsNeeded(T theResource, RequestDetails theRequestDetails) {
        List<IBaseResource> output = HashMapResourceProvider.fireInterceptorsAndFilterAsNeeded(Lists.newArrayList((Object[])new IBaseResource[]{theResource}), theRequestDetails);
        if (output.size() == 1) {
            return theResource;
        }
        return null;
    }

    protected static <T extends IBaseResource> List<IBaseResource> fireInterceptorsAndFilterAsNeeded(List<T> theResources, RequestDetails theRequestDetails) {
        List<IBaseResource> resourcesToReturn = new ArrayList<IBaseResource>(theResources);
        if (theRequestDetails != null) {
            IInterceptorBroadcaster interceptorBroadcaster = theRequestDetails.getInterceptorBroadcaster();
            SimplePreResourceAccessDetails preResourceAccessDetails = new SimplePreResourceAccessDetails(resourcesToReturn);
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IPreResourceAccessDetails.class, (Object)preResourceAccessDetails);
            interceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, params);
            preResourceAccessDetails.applyFilterToList();
            SimplePreResourceShowDetails preResourceShowDetails = new SimplePreResourceShowDetails(resourcesToReturn);
            HookParams preShowParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(IPreResourceShowDetails.class, (Object)preResourceShowDetails);
            interceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, preShowParams);
            resourcesToReturn = preResourceShowDetails.toList();
        }
        return resourcesToReturn;
    }
}

