/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.AppliesTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationFlagsEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class RuleImplConditional
extends BaseRule
implements IAuthRule {
    private AppliesTypeEnum myAppliesTo;
    private Set<String> myAppliesToTypes;
    private RestOperationTypeEnum myOperationType;

    RuleImplConditional(String theRuleName) {
        super(theRuleName);
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier, Set<AuthorizationFlagsEnum> theFlags, Pointcut thePointcut) {
        assert (theInputResource == null || theOutputResource == null);
        if (theInputResourceId != null && theInputResourceId.hasIdPart()) {
            return null;
        }
        if (theOperation == this.myOperationType) {
            if (theRequestDetails.getConditionalUrl(this.myOperationType) == null) {
                return null;
            }
            if (theInputResource == null) {
                return null;
            }
            switch (this.myAppliesTo) {
                case ALL_RESOURCES: 
                case INSTANCES: {
                    break;
                }
                case TYPES: {
                    String inputResourceName;
                    String resourceName;
                    if (!(this.myOperationType == RestOperationTypeEnum.DELETE ? !this.myAppliesToTypes.contains(resourceName = theRequestDetails.getResourceName()) : !this.myAppliesToTypes.contains(inputResourceName = theRequestDetails.getFhirContext().getResourceType(theInputResource)))) break;
                    return null;
                }
            }
            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, theRuleApplier);
        }
        return null;
    }

    void setAppliesTo(AppliesTypeEnum theAppliesTo) {
        this.myAppliesTo = theAppliesTo;
    }

    void setAppliesToTypes(Set<String> theAppliesToTypes) {
        this.myAppliesToTypes = theAppliesToTypes;
    }

    void setOperationType(RestOperationTypeEnum theOperationType) {
        this.myOperationType = theOperationType;
    }
}

