/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationFlagsEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBulkExportImpl
extends BaseRule {
    private static final Logger ourLog = LoggerFactory.getLogger(RuleBulkExportImpl.class);
    private String myGroupId;
    private final Collection<String> myPatientIds = new ArrayList<String>();
    private BulkExportJobParameters.ExportStyle myWantExportStyle;
    private Collection<String> myResourceTypes;
    private boolean myWantAnyStyle;

    RuleBulkExportImpl(String theRuleName) {
        super(theRuleName);
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier, Set<AuthorizationFlagsEnum> theFlags, Pointcut thePointcut) {
        String actualGroupId;
        String expectedGroupId;
        if (thePointcut != Pointcut.STORAGE_INITIATE_BULK_EXPORT) {
            return null;
        }
        if (theRequestDetails == null) {
            return null;
        }
        BulkExportJobParameters options = (BulkExportJobParameters)((Object)theRequestDetails.getAttribute(AuthorizationInterceptor.REQUEST_ATTRIBUTE_BULK_DATA_EXPORT_OPTIONS));
        if (!this.myWantAnyStyle && options.getExportStyle() != this.myWantExportStyle) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(this.myResourceTypes)) {
            if (CollectionUtils.isEmpty(options.getResourceTypes())) {
                return null;
            }
            for (String next : options.getResourceTypes()) {
                if (this.myResourceTypes.contains(next)) continue;
                return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
            }
        }
        if (this.myWantAnyStyle || this.myWantExportStyle == BulkExportJobParameters.ExportStyle.SYSTEM) {
            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, theRuleApplier);
        }
        if (StringUtils.isNotBlank((CharSequence)this.myGroupId) && options.getGroupId() != null && Objects.equals(expectedGroupId = new IdDt(this.myGroupId).toUnqualifiedVersionless().getValue(), actualGroupId = new IdDt(options.getGroupId()).toUnqualifiedVersionless().getValue())) {
            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, theRuleApplier);
        }
        if (this.myWantExportStyle == BulkExportJobParameters.ExportStyle.PATIENT && CollectionUtils.isNotEmpty(this.myPatientIds)) {
            List permittedPatientIds = this.myPatientIds.stream().map(id -> new IdDt(id).toUnqualifiedVersionless().getValue()).collect(Collectors.toList());
            if (!options.getPatientIds().isEmpty()) {
                ourLog.debug("options.getPatientIds() != null");
                List requestedPatientIds = options.getPatientIds().stream().map(t -> new IdDt(t).toUnqualifiedVersionless().getValue()).collect(Collectors.toList());
                boolean requestedPatientsPermitted = true;
                for (String requestedPatientId : requestedPatientIds) {
                    if (permittedPatientIds.contains(requestedPatientId)) continue;
                    requestedPatientsPermitted = false;
                    break;
                }
                if (requestedPatientsPermitted) {
                    return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, theRuleApplier);
                }
                return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
            }
            List<String> filters = options.getFilters();
            if (!filters.isEmpty()) {
                ourLog.debug("filters not empty");
                Set patientIdsInFilters = filters.stream().filter(filter -> filter.startsWith("Patient?_id=")).map(filter -> filter.replace("?_id=", "/")).collect(Collectors.toUnmodifiableSet());
                boolean filteredPatientIdsPermitted = true;
                for (String patientIdInFilters : patientIdsInFilters) {
                    if (permittedPatientIds.contains(patientIdInFilters)) continue;
                    filteredPatientIdsPermitted = false;
                    break;
                }
                if (filteredPatientIdsPermitted) {
                    return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, theRuleApplier);
                }
                return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
            }
            ourLog.debug("patientIds and filters both empty");
        }
        return null;
    }

    public void setAppliesToGroupExportOnGroup(String theGroupId) {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.GROUP;
        this.myGroupId = theGroupId;
    }

    public void setAppliesToPatientExportOnGroup(String theGroupId) {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.PATIENT;
        this.myGroupId = theGroupId;
    }

    public void setAppliesToPatientExport(String thePatientId) {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.PATIENT;
        this.myPatientIds.add(thePatientId);
    }

    public void setAppliesToSystem() {
        this.myWantExportStyle = BulkExportJobParameters.ExportStyle.SYSTEM;
    }

    public void setResourceTypes(Collection<String> theResourceTypes) {
        this.myResourceTypes = theResourceTypes;
    }

    public void setAppliesToAny() {
        this.myWantAnyStyle = true;
    }

    String getGroupId() {
        return this.myGroupId;
    }

    BulkExportJobParameters.ExportStyle getWantExportStyle() {
        return this.myWantExportStyle;
    }
}

