/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.i18n.Msg;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AdditionalCompartmentSearchParameters {
    private Map<String, Set<String>> myResourceTypeToParameterCodeMap = new HashMap<String, Set<String>>();

    public void addSearchParameters(String ... theQualifiedSearchParameters) {
        Arrays.stream(theQualifiedSearchParameters).forEach(code -> {
            if (code == null || !code.contains(":")) {
                throw new IllegalArgumentException(Msg.code((int)341) + code + " is not a valid search parameter. Search parameters must be in the form resourcetype:parametercode, e.g. 'Device:patient'");
            }
            String[] split = code.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException(Msg.code((int)342) + code + " is not a valid search parameter. Search parameters must be in the form resourcetype:parametercode, e.g. 'Device:patient'");
            }
            this.myResourceTypeToParameterCodeMap.computeIfAbsent(split[0].toLowerCase(), key -> new HashSet()).add(split[1].toLowerCase());
        });
    }

    public Set<String> getSearchParamNamesForResourceType(@Nonnull String theResourceType) {
        return this.myResourceTypeToParameterCodeMap.computeIfAbsent(theResourceType.toLowerCase(), key -> new HashSet());
    }
}

