/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.RestfulServer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IncomingRequestAddressStrategy
implements IServerAddressStrategy {
    private String myServletPath;

    @Override
    public String determineServerBase(ServletContext theServletContext, HttpServletRequest theRequest) {
        int contextIndex;
        if (theRequest == null) {
            return null;
        }
        String requestFullPath = StringUtils.defaultString((String)theRequest.getRequestURI());
        String servletPath = this.myServletPath != null ? this.myServletPath : StringUtils.defaultString((String)theRequest.getServletPath());
        StringBuffer requestUrl = theRequest.getRequestURL();
        String servletContextPath = StringUtils.defaultString((String)theRequest.getContextPath());
        String requestPath = requestFullPath.substring(servletContextPath.length() + servletPath.length());
        if (requestPath.length() > 0 && requestPath.charAt(0) == '/') {
            requestPath = requestPath.substring(1);
        }
        int startOfPath = requestUrl.indexOf("//");
        int requestUrlLength = requestUrl.length();
        if (startOfPath != -1 && startOfPath + 2 < requestUrlLength) {
            startOfPath = requestUrl.indexOf("/", startOfPath + 2);
        }
        if (startOfPath == -1) {
            startOfPath = 0;
        }
        if (servletPath.length() == 0 || servletPath.equals("/")) {
            contextIndex = requestPath.length() == 0 ? requestUrlLength : requestUrl.indexOf(requestPath, startOfPath);
        } else {
            contextIndex = requestUrl.indexOf(servletPath + "/", startOfPath);
            if (contextIndex == -1) {
                contextIndex = requestUrl.indexOf(servletPath, startOfPath);
            }
        }
        int length = contextIndex + servletPath.length();
        if (length > requestUrlLength) {
            length = requestUrlLength;
        }
        String fhirServerBase = requestUrl.substring(0, length);
        return fhirServerBase;
    }

    public void setServletPath(String theServletPath) {
        this.myServletPath = theServletPath;
    }

    public static String determineServletContextPath(HttpServletRequest theRequest, RestfulServer server) {
        String retVal = server.getServletContext() != null ? (server.getServletContext().getMajorVersion() >= 3 || server.getServletContext().getMajorVersion() > 2 && server.getServletContext().getMinorVersion() >= 5 ? server.getServletContext().getContextPath() : theRequest.getContextPath()) : theRequest.getContextPath();
        retVal = StringUtils.defaultString((String)retVal);
        return retVal;
    }
}

