/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server.storage;

import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IIdType;

public abstract class BaseResourcePersistentId<T>
implements IResourcePersistentId<T> {
    private Long myVersion;
    private final String myResourceType;
    private IIdType myAssociatedResourceId;

    protected BaseResourcePersistentId(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    protected BaseResourcePersistentId(Long theVersion, String theResourceType) {
        this.myVersion = theVersion;
        this.myResourceType = theResourceType;
    }

    @Override
    public IIdType getAssociatedResourceId() {
        return this.myAssociatedResourceId;
    }

    @Override
    public IResourcePersistentId<T> setAssociatedResourceId(IIdType theAssociatedResourceId) {
        this.myAssociatedResourceId = theAssociatedResourceId;
        return this;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        BaseResourcePersistentId that = (BaseResourcePersistentId)theO;
        return Objects.equals(this.myVersion, that.myVersion);
    }

    public int hashCode() {
        return Objects.hash(this.myVersion);
    }

    @Override
    public Long getVersion() {
        return this.myVersion;
    }

    @Override
    public void setVersion(Long theVersion) {
        this.myVersion = theVersion;
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }
}

