/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.AddProfileTagEnum;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.ElementsSupportEnum;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;

public class SystemRequestDetails
extends RequestDetails {
    private FhirContext myFhirContext;
    private ListMultimap<String, String> myHeaders;
    private RequestPartitionId myRequestPartitionId;
    private IRestfulServerDefaults myServer = new MyRestfulServerDefaults();

    public SystemRequestDetails() {
        this(new MyInterceptorBroadcaster());
    }

    public SystemRequestDetails(IInterceptorBroadcaster theInterceptorBroadcaster) {
        super(theInterceptorBroadcaster);
    }

    public SystemRequestDetails(RequestDetails theDetails) {
        super(theDetails);
        if (Objects.nonNull(theDetails.getServer())) {
            this.myServer = theDetails.getServer();
            this.myFhirContext = theDetails.getFhirContext();
        }
    }

    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }

    public SystemRequestDetails setRequestPartitionId(RequestPartitionId theRequestPartitionId) {
        this.myRequestPartitionId = theRequestPartitionId;
        return this;
    }

    @Override
    protected byte[] getByteStreamRequestContents() {
        return new byte[0];
    }

    @Override
    public Charset getCharset() {
        return null;
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public void setFhirContext(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    @Override
    public String getHeader(String name) {
        List<String> headers = this.getHeaders(name);
        if (headers.isEmpty()) {
            return null;
        }
        return headers.get(0);
    }

    @Override
    public List<String> getHeaders(String name) {
        ImmutableListMultimap headers = this.myHeaders;
        if (headers == null) {
            headers = ImmutableListMultimap.of();
        }
        return headers.get((Object)name);
    }

    public void addHeader(String theName, String theValue) {
        if (this.myHeaders == null) {
            this.myHeaders = ArrayListMultimap.create();
        }
        this.myHeaders.put((Object)theName, (Object)theValue);
    }

    @Override
    public Object getAttribute(String theAttributeName) {
        return null;
    }

    @Override
    public void setAttribute(String theAttributeName, Object theAttributeValue) {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public Reader getReader() throws IOException {
        return null;
    }

    @Override
    public IRestfulServerDefaults getServer() {
        return this.myServer;
    }

    public void setServer(RestfulServer theServer) {
        this.myServer = theServer;
    }

    @Override
    public String getServerBaseForRequest() {
        return null;
    }

    public static SystemRequestDetails forAllPartitions() {
        return new SystemRequestDetails().setRequestPartitionId(RequestPartitionId.allPartitions());
    }

    public static SystemRequestDetails newSystemRequestAllPartitions() {
        SystemRequestDetails systemRequestDetails = new SystemRequestDetails();
        systemRequestDetails.setRequestPartitionId(RequestPartitionId.allPartitions());
        return systemRequestDetails;
    }

    private static class MyInterceptorBroadcaster
    implements IInterceptorBroadcaster {
        private MyInterceptorBroadcaster() {
        }

        public boolean callHooks(Pointcut thePointcut, HookParams theParams) {
            return true;
        }

        public Object callHooksAndReturnObject(Pointcut thePointcut, HookParams theParams) {
            return null;
        }

        public boolean hasHooks(Pointcut thePointcut) {
            return false;
        }
    }

    private static class MyRestfulServerDefaults
    implements IRestfulServerDefaults {
        private MyRestfulServerDefaults() {
        }

        @Override
        public AddProfileTagEnum getAddProfileTag() {
            return null;
        }

        @Override
        public EncodingEnum getDefaultResponseEncoding() {
            return null;
        }

        @Override
        public ETagSupportEnum getETagSupport() {
            return null;
        }

        @Override
        public ElementsSupportEnum getElementsSupport() {
            return null;
        }

        @Override
        public FhirContext getFhirContext() {
            return null;
        }

        @Override
        public List<IServerInterceptor> getInterceptors_() {
            return null;
        }

        @Override
        public IPagingProvider getPagingProvider() {
            return null;
        }

        @Override
        public boolean isDefaultPrettyPrint() {
            return false;
        }

        @Override
        public IInterceptorService getInterceptorService() {
            return null;
        }
    }
}

