/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.servlet;

import ca.uhn.fhir.rest.server.BaseRestfulResponse;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ServletRestfulResponse
extends BaseRestfulResponse<ServletRequestDetails> {
    private Writer myWriter;
    private OutputStream myOutputStream;

    public ServletRestfulResponse(ServletRequestDetails servletRequestDetails) {
        super(servletRequestDetails);
    }

    @Override
    @Nonnull
    public OutputStream getResponseOutputStream(int theStatusCode, String theContentType, Integer theContentLength) throws IOException {
        Validate.isTrue((this.myWriter == null ? 1 : 0) != 0, (String)"getResponseOutputStream() called multiple times", (Object[])new Object[0]);
        Validate.isTrue((this.myOutputStream == null ? 1 : 0) != 0, (String)"getResponseOutputStream() called after getResponseWriter()", (Object[])new Object[0]);
        this.addHeaders();
        HttpServletResponse httpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        httpResponse.setStatus(theStatusCode);
        httpResponse.setContentType(theContentType);
        httpResponse.setCharacterEncoding(null);
        if (theContentLength != null) {
            httpResponse.setContentLength(theContentLength.intValue());
        }
        this.myOutputStream = httpResponse.getOutputStream();
        return this.myOutputStream;
    }

    @Override
    @Nonnull
    public Writer getResponseWriter(int theStatusCode, String theContentType, String theCharset, boolean theRespondGzip) throws IOException {
        Validate.isTrue((this.myOutputStream == null ? 1 : 0) != 0, (String)"getResponseWriter() called after getResponseOutputStream()", (Object[])new Object[0]);
        this.addHeaders();
        HttpServletResponse theHttpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        theHttpResponse.setCharacterEncoding(theCharset);
        theHttpResponse.setStatus(theStatusCode);
        theHttpResponse.setContentType(theContentType);
        if (theRespondGzip) {
            theHttpResponse.addHeader("Content-Encoding", "gzip");
            ServletOutputStream outputStream = theHttpResponse.getOutputStream();
            this.myWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)outputStream), StandardCharsets.UTF_8);
            return this.myWriter;
        }
        this.myWriter = theHttpResponse.getWriter();
        return this.myWriter;
    }

    private void addHeaders() {
        HttpServletResponse httpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        ((ServletRequestDetails)this.getRequestDetails()).getServer().addHeadersToResponse(httpResponse);
        for (Map.Entry<String, List<String>> header : this.getHeaders().entrySet()) {
            String key = header.getKey();
            key = ServletRestfulResponse.sanitizeHeaderField(key);
            boolean first = true;
            for (String value : header.getValue()) {
                value = ServletRestfulResponse.sanitizeHeaderField(value);
                if (first) {
                    httpResponse.setHeader(key, value);
                    first = false;
                    continue;
                }
                httpResponse.addHeader(key, value);
            }
        }
    }

    @Override
    public final Object commitResponse(@Nonnull Closeable theWriterOrOutputStream) {
        IoUtil.closeQuietly((AutoCloseable)theWriterOrOutputStream);
        return null;
    }

    static String sanitizeHeaderField(String theKey) {
        return StringUtils.replaceChars((String)theKey, (String)"\r\n", null);
    }
}

