/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation.address;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.ConfigLoader;
import ca.uhn.fhir.rest.server.interceptor.validation.address.AddressValidationResult;
import ca.uhn.fhir.rest.server.interceptor.validation.address.IAddressValidator;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.TerserUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class AddressValidatingInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(AddressValidatingInterceptor.class);
    public static final String ADDRESS_TYPE_NAME = "Address";
    public static final String PROPERTY_VALIDATOR_CLASS = "validator.class";
    public static final String PROPERTY_EXTENSION_URL = "extension.url";
    public static final String ADDRESS_VALIDATION_DISABLED_HEADER = "HAPI-Address-Validation-Disabled";
    private IAddressValidator myAddressValidator;
    private Properties myProperties;

    public AddressValidatingInterceptor() {
        ourLog.info("Starting AddressValidatingInterceptor {}", (Object)this);
        this.myProperties = ConfigLoader.loadProperties("classpath:address-validation.properties");
        this.start(this.myProperties);
    }

    public AddressValidatingInterceptor(Properties theProperties) {
        this.myProperties = theProperties;
        this.start(theProperties);
    }

    public void start(Properties theProperties) {
        if (!theProperties.containsKey(PROPERTY_VALIDATOR_CLASS)) {
            ourLog.info("Address validator class is not defined. Validation is disabled");
            return;
        }
        String validatorClassName = theProperties.getProperty(PROPERTY_VALIDATOR_CLASS);
        Validate.notBlank((CharSequence)validatorClassName, (String)"%s property can not be blank", (Object[])new Object[]{PROPERTY_VALIDATOR_CLASS});
        ourLog.info("Using address validator {}", (Object)validatorClassName);
        try {
            IAddressValidator addressValidator;
            Class<?> validatorClass = Class.forName(validatorClassName);
            try {
                addressValidator = (IAddressValidator)validatorClass.getDeclaredConstructor(Properties.class).newInstance(theProperties);
            }
            catch (Exception e) {
                addressValidator = (IAddressValidator)validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.setAddressValidator(addressValidator);
        }
        catch (Exception e) {
            throw new RuntimeException(Msg.code((int)344) + "Unable to create validator", e);
        }
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void resourcePreCreate(RequestDetails theRequest, IBaseResource theResource) {
        ourLog.debug("Validating address on for create {}, {}", (Object)theResource, (Object)theRequest);
        this.handleRequest(theRequest, theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void resourcePreUpdate(RequestDetails theRequest, IBaseResource theOldResource, IBaseResource theNewResource) {
        ourLog.debug("Validating address on for update {}, {}, {}", new Object[]{theOldResource, theNewResource, theRequest});
        this.handleRequest(theRequest, theNewResource);
    }

    protected void handleRequest(RequestDetails theRequest, IBaseResource theResource) {
        if (this.getAddressValidator() == null) {
            ourLog.debug("Address validator is not provided - validation disabled");
            return;
        }
        if (theRequest == null) {
            ourLog.debug("RequestDetails is null - unable to validate address for {}", (Object)theResource);
            return;
        }
        if (!theRequest.getHeaders(ADDRESS_VALIDATION_DISABLED_HEADER).isEmpty()) {
            ourLog.debug("Address validation is disabled for this request via header");
            return;
        }
        FhirContext ctx = theRequest.getFhirContext();
        List<IBase> addresses = this.getAddresses(theResource, ctx).stream().filter(this::isValidating).collect(Collectors.toList());
        if (!addresses.isEmpty()) {
            this.validateAddresses(theRequest, theResource, addresses);
        }
    }

    protected boolean validateAddresses(RequestDetails theRequest, IBaseResource theResource, List<IBase> theAddresses) {
        boolean retVal = true;
        for (IBase address : theAddresses) {
            retVal &= this.validateAddress(address, theRequest.getFhirContext());
        }
        return retVal;
    }

    private boolean isValidating(IBase theAddress) {
        IBaseExtension ext = ExtensionUtil.getExtensionByUrl((IBase)theAddress, (String)this.getExtensionUrl());
        if (ext == null) {
            return true;
        }
        if (ext.getValue() == null || ext.getValue().isEmpty()) {
            return true;
        }
        return !"false".equals(ext.getValue().toString());
    }

    protected boolean validateAddress(IBase theAddress, FhirContext theFhirContext) {
        ExtensionUtil.clearExtensionsByUrl((IBase)theAddress, (String)this.getExtensionUrl());
        try {
            AddressValidationResult validationResult = this.getAddressValidator().isValid(theAddress, theFhirContext);
            ourLog.debug("Validated address {}", (Object)validationResult);
            this.clearPossibleDuplicatesDueToTerserCloning(theAddress, theFhirContext);
            ExtensionUtil.setExtension((FhirContext)theFhirContext, (IBase)theAddress, (String)this.getExtensionUrl(), (String)"boolean", (Object)(!validationResult.isValid() ? 1 : 0));
            if (validationResult.getValidatedAddress() != null) {
                theFhirContext.newTerser().cloneInto(validationResult.getValidatedAddress(), theAddress, true);
            } else {
                ourLog.info("Validated address is not provided - skipping update on the target address instance");
            }
            return validationResult.isValid();
        }
        catch (Exception ex) {
            ourLog.warn("Unable to validate address", (Throwable)ex);
            IBaseExtension extension = ExtensionUtil.getOrCreateExtension((IBase)theAddress, (String)this.getExtensionUrl());
            IBaseExtension errorValue = ExtensionUtil.getOrCreateExtension((IBase)extension, (String)"error");
            errorValue.setValue((IBaseDatatype)TerserUtil.newElement((FhirContext)theFhirContext, (String)"string", (Object)ex.getMessage()));
            return false;
        }
    }

    private void clearPossibleDuplicatesDueToTerserCloning(IBase theAddress, FhirContext theFhirContext) {
        TerserUtil.clearField((FhirContext)theFhirContext, (String)"line", (IBase)theAddress);
        ExtensionUtil.clearExtensionsByUrl((IBase)theAddress, (String)this.getExtensionUrl());
    }

    protected String getExtensionUrl() {
        if (this.getProperties().containsKey(PROPERTY_EXTENSION_URL)) {
            return this.getProperties().getProperty(PROPERTY_EXTENSION_URL);
        }
        return "http://hapifhir.org/StructureDefinition/ext-validation-address-has-error";
    }

    protected List<IBase> getAddresses(IBaseResource theResource, FhirContext theFhirContext) {
        RuntimeResourceDefinition definition = theFhirContext.getResourceDefinition(theResource);
        ArrayList<IBase> retVal = new ArrayList<IBase>();
        for (BaseRuntimeChildDefinition c : definition.getChildren()) {
            Class<?> childClass = c.getClass();
            List allValues = c.getAccessor().getValues((IBase)theResource).stream().filter(v -> ADDRESS_TYPE_NAME.equals(v.getClass().getSimpleName())).collect(Collectors.toList());
            retVal.addAll(allValues);
        }
        return retVal;
    }

    public IAddressValidator getAddressValidator() {
        return this.myAddressValidator;
    }

    public void setAddressValidator(IAddressValidator theAddressValidator) {
        this.myAddressValidator = theAddressValidator;
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public void setProperties(Properties theProperties) {
        this.myProperties = theProperties;
    }
}

