/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.ClasspathUtil;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseConformance;

@Interceptor
public class StaticCapabilityStatementInterceptor {
    private String myCapabilityStatementResource;
    private volatile IBaseConformance myCapabilityStatement;

    public void setCapabilityStatement(IBaseConformance theCapabilityStatement) {
        this.myCapabilityStatement = theCapabilityStatement;
    }

    public void setCapabilityStatementResource(String theClasspath) {
        this.myCapabilityStatementResource = theClasspath;
        this.myCapabilityStatement = null;
    }

    @Hook(value=Pointcut.SERVER_CAPABILITY_STATEMENT_GENERATED)
    public IBaseConformance hook(RequestDetails theRequestDetails) {
        IBaseConformance retVal = this.myCapabilityStatement;
        if (retVal == null) {
            Validate.notBlank((CharSequence)this.myCapabilityStatementResource, (String)"No CapabilityStatement defined", (Object[])new Object[0]);
            String output = ClasspathUtil.loadResource((String)this.myCapabilityStatementResource);
            FhirContext ctx = theRequestDetails.getFhirContext();
            EncodingEnum encoding = EncodingEnum.detectEncodingNoDefault((String)output);
            Validate.notNull((Object)encoding, (String)"Could not determine FHIR encoding for resource: %s", (Object[])new Object[]{this.myCapabilityStatementResource});
            this.myCapabilityStatement = retVal = (IBaseConformance)encoding.newParser(ctx).parseResource(output);
        }
        return retVal;
    }
}

