/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.jpa.mdm.svc.MdmResourceDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateList;
import ca.uhn.fhir.jpa.mdm.svc.candidate.FindCandidateByEidSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.FindCandidateByExampleSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.FindCandidateByLinkSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmGoldenResourceFindingSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private MdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    private FindCandidateByEidSvc myFindCandidateByEidSvc;
    @Autowired
    private FindCandidateByLinkSvc myFindCandidateByLinkSvc;
    @Autowired
    private FindCandidateByExampleSvc myFindCandidateByExampleSvc;

    public CandidateList findGoldenResourceCandidates(IAnyResource theResource) {
        CandidateList matchedGoldenResourceCandidates = this.myFindCandidateByEidSvc.findCandidates(theResource);
        if (matchedGoldenResourceCandidates.isEmpty()) {
            matchedGoldenResourceCandidates = this.myFindCandidateByLinkSvc.findCandidates(theResource);
        }
        if (matchedGoldenResourceCandidates.isEmpty()) {
            matchedGoldenResourceCandidates = this.myFindCandidateByExampleSvc.findCandidates(theResource);
        }
        return matchedGoldenResourceCandidates;
    }

    public IAnyResource getGoldenResourceFromMatchedGoldenResourceCandidate(MatchedGoldenResourceCandidate theMatchedGoldenResourceCandidate, String theResourceType) {
        ResourcePersistentId goldenResourcePid = theMatchedGoldenResourceCandidate.getCandidateGoldenResourcePid();
        return this.myMdmResourceDaoSvc.readGoldenResourceByPid(goldenResourcePid, theResourceType);
    }
}

