/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.interceptor;

import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionSubmitInterceptorLoader;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.interceptor.IMdmStorageInterceptor;
import ca.uhn.fhir.mdm.interceptor.MdmSearchExpandingInterceptor;
import ca.uhn.fhir.mdm.log.Logs;
import javax.annotation.PostConstruct;
import org.hl7.fhir.dstu2.model.Subscription;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MdmSubmitterInterceptorLoader {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    DaoConfig myDaoConfig;
    @Autowired
    private IMdmStorageInterceptor myIMdmStorageInterceptor;
    @Autowired
    private MdmSearchExpandingInterceptor myMdmSearchExpandingInterceptorInterceptor;
    @Autowired
    private IInterceptorService myInterceptorService;
    @Autowired
    private SubscriptionSubmitInterceptorLoader mySubscriptionSubmitInterceptorLoader;

    @PostConstruct
    public void start() {
        if (!this.myMdmSettings.isEnabled()) {
            return;
        }
        this.myDaoConfig.addSupportedSubscriptionType(Subscription.SubscriptionChannelType.MESSAGE);
        this.myInterceptorService.registerInterceptor((Object)this.myIMdmStorageInterceptor);
        this.myInterceptorService.registerInterceptor((Object)this.myMdmSearchExpandingInterceptorInterceptor);
        ourLog.info("MDM interceptor registered");
        this.mySubscriptionSubmitInterceptorLoader.start();
    }
}

