/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.broker;

import ca.uhn.fhir.jpa.mdm.broker.MdmMessageHandler;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelConsumerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.log.Logs;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageHandler;
import org.springframework.stereotype.Service;

@Service
public class MdmQueueConsumerLoader {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private MdmMessageHandler myMdmMessageHandler;
    @Autowired
    private IChannelFactory myChannelFactory;
    @Autowired
    private IMdmSettings myMdmSettings;
    protected IChannelReceiver myMdmChannel;

    @PostConstruct
    public void startListeningToMdmChannel() {
        if (this.myMdmChannel == null) {
            ChannelConsumerSettings config = new ChannelConsumerSettings();
            config.setConcurrentConsumers(this.myMdmSettings.getConcurrentConsumers());
            this.myMdmChannel = this.myChannelFactory.getOrCreateReceiver("empi", ResourceModifiedJsonMessage.class, config);
            if (this.myMdmChannel == null) {
                ourLog.error("Unable to create receiver for {}", (Object)"empi");
            } else {
                this.myMdmChannel.subscribe((MessageHandler)this.myMdmMessageHandler);
                ourLog.info("MDM Matching Consumer subscribed to Matching Channel {} with name {}", (Object)this.myMdmChannel.getClass().getName(), (Object)this.myMdmChannel.getName());
            }
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.myMdmChannel != null) {
            this.myMdmChannel.destroy();
            ourLog.info("MDM Matching Consumer unsubscribed from Matching Channel {} with name {}", (Object)this.myMdmChannel.getClass().getName(), (Object)this.myMdmChannel.getName());
        }
    }

    @VisibleForTesting
    public IChannelReceiver getMdmChannelForUnitTest() {
        return this.myMdmChannel;
    }
}

