/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class SearchParameterUtil {
    public static List<String> getBaseAsStrings(FhirContext theContext, IBaseResource theResource) {
        Validate.notNull((Object)theContext, (String)"theContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theResource);
        BaseRuntimeChildDefinition base = def.getChildByName("base");
        List<IBase> baseValues = base.getAccessor().getValues(theResource);
        ArrayList<String> retVal = new ArrayList<String>();
        for (IBase next : baseValues) {
            IPrimitiveType nextPrimitive = (IPrimitiveType)next;
            retVal.add(nextPrimitive.getValueAsString());
        }
        return retVal;
    }

    public static Optional<RuntimeSearchParam> getOnlyPatientSearchParamForResourceType(FhirContext theFhirContext, String theResourceType) {
        RuntimeSearchParam myPatientSearchParam = null;
        RuntimeResourceDefinition runtimeResourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        myPatientSearchParam = runtimeResourceDefinition.getSearchParam("patient");
        if (myPatientSearchParam == null && (myPatientSearchParam = runtimeResourceDefinition.getSearchParam("subject")) == null) {
            myPatientSearchParam = SearchParameterUtil.getOnlyPatientCompartmentRuntimeSearchParam(runtimeResourceDefinition);
        }
        return Optional.ofNullable(myPatientSearchParam);
    }

    public static RuntimeSearchParam getOnlyPatientCompartmentRuntimeSearchParam(FhirContext theFhirContext, String theResourceType) {
        RuntimeResourceDefinition resourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        return SearchParameterUtil.getOnlyPatientCompartmentRuntimeSearchParam(resourceDefinition);
    }

    public static RuntimeSearchParam getOnlyPatientCompartmentRuntimeSearchParam(RuntimeResourceDefinition runtimeResourceDefinition) {
        List<RuntimeSearchParam> searchParams = runtimeResourceDefinition.getSearchParamsForCompartmentName("Patient");
        if (searchParams == null || searchParams.size() == 0) {
            String errorMessage = String.format("Resource type [%s] is not eligible for this type of export, as it contains no Patient compartment, and no `patient` or `subject` search parameter", runtimeResourceDefinition.getId());
            throw new IllegalArgumentException(Msg.code(1774) + errorMessage);
        }
        if (searchParams.size() != 1) {
            String errorMessage = String.format("Resource type %s has more than one Search Param which references a patient compartment. We are unable to disambiguate which patient search parameter we should be searching by.", runtimeResourceDefinition.getId());
            throw new IllegalArgumentException(Msg.code(1775) + errorMessage);
        }
        RuntimeSearchParam patientSearchParam = searchParams.get(0);
        return patientSearchParam;
    }

    public static List<RuntimeSearchParam> getAllPatientCompartmentRuntimeSearchParams(FhirContext theFhirContext, String theResourceType) {
        RuntimeResourceDefinition runtimeResourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        return SearchParameterUtil.getAllPatientCompartmentRuntimeSearchParams(runtimeResourceDefinition);
    }

    private static List<RuntimeSearchParam> getAllPatientCompartmentRuntimeSearchParams(RuntimeResourceDefinition theRuntimeResourceDefinition) {
        List<RuntimeSearchParam> patient = theRuntimeResourceDefinition.getSearchParamsForCompartmentName("Patient");
        return patient;
    }

    public static boolean isResourceTypeInPatientCompartment(FhirContext theFhirContext, String theResourceType) {
        RuntimeResourceDefinition runtimeResourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        return SearchParameterUtil.getAllPatientCompartmentRuntimeSearchParams(runtimeResourceDefinition).size() > 0;
    }

    @Nullable
    public static String getCode(FhirContext theContext, IBaseResource theResource) {
        return SearchParameterUtil.getStringChild(theContext, theResource, "code");
    }

    @Nullable
    public static String getURL(FhirContext theContext, IBaseResource theResource) {
        return SearchParameterUtil.getStringChild(theContext, theResource, "url");
    }

    @Nullable
    public static String getExpression(FhirContext theFhirContext, IBaseResource theResource) {
        return SearchParameterUtil.getStringChild(theFhirContext, theResource, "expression");
    }

    private static String getStringChild(FhirContext theFhirContext, IBaseResource theResource, String theChildName) {
        Validate.notNull((Object)theFhirContext, (String)"theContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        RuntimeResourceDefinition def = theFhirContext.getResourceDefinition(theResource);
        BaseRuntimeChildDefinition base = def.getChildByName(theChildName);
        return base.getAccessor().getFirstValueOrNull(theResource).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
    }

    public static String stripModifier(String theSearchParam) {
        int colonIndex = theSearchParam.indexOf(":");
        String retval = colonIndex == -1 ? theSearchParam : theSearchParam.substring(0, colonIndex);
        return retval;
    }
}

