/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.composite.BaseQuantityDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.BaseParamWithPrefix;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.util.CoverageIgnore;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class QuantityParam
extends BaseParamWithPrefix<QuantityParam>
implements IQueryParameterType {
    private static final long serialVersionUID = 1L;
    private BigDecimal myValue;
    private String mySystem;
    private String myUnits;

    public QuantityParam() {
    }

    public QuantityParam(ParamPrefixEnum thePrefix, BigDecimal theValue, String theSystem, String theUnits) {
        this.setPrefix(thePrefix);
        this.setValue(theValue);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    public QuantityParam(ParamPrefixEnum thePrefix, double theValue, String theSystem, String theUnits) {
        this.setPrefix(thePrefix);
        this.setValue(theValue);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    public QuantityParam(ParamPrefixEnum thePrefix, long theValue, String theSystem, String theUnits) {
        this.setPrefix(thePrefix);
        this.setValue(theValue);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    public QuantityParam(String theQuantity) {
        this.setValueAsQueryToken(null, null, null, theQuantity);
    }

    public QuantityParam(long theQuantity) {
        this.setValueAsQueryToken(null, null, null, Long.toString(theQuantity));
    }

    public QuantityParam(String theQuantity, String theSystem, String theUnits) {
        this.setValueAsQueryToken(null, null, null, theQuantity);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    private void clear() {
        this.setPrefix(null);
        this.setSystem((String)null);
        this.setUnits(null);
        this.setValue((BigDecimal)null);
    }

    @Override
    String doGetQueryParameterQualifier() {
        return null;
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        StringBuilder b = new StringBuilder();
        if (this.getPrefix() != null) {
            b.append(ParameterUtil.escapeWithDefault(this.getPrefix().getValue()));
        }
        b.append(ParameterUtil.escapeWithDefault(this.getValueAsString()));
        b.append('|');
        b.append(ParameterUtil.escapeWithDefault(this.mySystem));
        b.append('|');
        b.append(ParameterUtil.escapeWithDefault(this.myUnits));
        return b.toString();
    }

    public String getValueAsString() {
        if (this.myValue != null) {
            return this.myValue.toPlainString();
        }
        return null;
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        this.clear();
        if (theValue == null) {
            return;
        }
        List<String> parts = ParameterUtil.splitParameterString(theValue, '|', true);
        if (parts.size() > 0 && StringUtils.isNotBlank((CharSequence)parts.get(0))) {
            String value = super.extractPrefixAndReturnRest(parts.get(0));
            this.setValue(value);
        }
        if (parts.size() > 1 && StringUtils.isNotBlank((CharSequence)parts.get(1))) {
            this.setSystem(parts.get(1));
        }
        if (parts.size() > 2 && StringUtils.isNotBlank((CharSequence)parts.get(2))) {
            this.setUnits(parts.get(2));
        }
    }

    public String getSystem() {
        return this.mySystem;
    }

    @Deprecated
    @CoverageIgnore
    public UriDt getSystemAsUriDt() {
        return new UriDt(this.mySystem);
    }

    public String getUnits() {
        return this.myUnits;
    }

    public BigDecimal getValue() {
        return this.myValue;
    }

    public QuantityParam setSystem(String theSystem) {
        this.mySystem = theSystem;
        return this;
    }

    public QuantityParam setSystem(IPrimitiveType<String> theSystem) {
        this.mySystem = null;
        if (theSystem != null) {
            this.mySystem = theSystem.getValue();
        }
        return this;
    }

    public QuantityParam setUnits(String theUnits) {
        this.myUnits = theUnits;
        return this;
    }

    public QuantityParam setValue(BigDecimal theValue) {
        this.myValue = theValue;
        return this;
    }

    public QuantityParam setValue(IPrimitiveType<BigDecimal> theValue) {
        this.myValue = null;
        if (theValue != null) {
            this.myValue = theValue.getValue();
        }
        return this;
    }

    public QuantityParam setValue(String theValue) {
        this.myValue = null;
        if (theValue != null) {
            this.myValue = new BigDecimal(theValue);
        }
        return this;
    }

    public QuantityParam setValue(double theValue) {
        this.myValue = BigDecimal.valueOf(theValue);
        return this;
    }

    public QuantityParam setValue(long theValue) {
        this.myValue = BigDecimal.valueOf(theValue);
        return this;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("prefix", (Object)this.getPrefix());
        b.append("value", (Object)this.myValue);
        b.append("system", (Object)this.mySystem);
        b.append("units", (Object)this.myUnits);
        if (this.getMissing() != null) {
            b.append("missing", (Object)this.getMissing());
        }
        return b.toString();
    }

    public static QuantityParam toQuantityParam(IQueryParameterType theParam) {
        if (theParam instanceof BaseQuantityDt) {
            BaseQuantityDt param = (BaseQuantityDt)theParam;
            String systemValue = param.getSystemElement().getValueAsString();
            String unitsValue = param.getUnitsElement().getValueAsString();
            ParamPrefixEnum cmpValue = ParamPrefixEnum.forValue(param.getComparatorElement().getValueAsString());
            BigDecimal valueValue = (BigDecimal)param.getValueElement().getValue();
            return ((QuantityParam)new QuantityParam().setSystem(systemValue).setUnits(unitsValue).setPrefix(cmpValue)).setValue(valueValue);
        }
        if (theParam instanceof QuantityParam) {
            return (QuantityParam)theParam;
        }
        throw new IllegalArgumentException(Msg.code(1948) + "Invalid quantity type: " + theParam.getClass());
    }
}

