/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.parser.DataFormatException;
import org.hl7.fhir.instance.model.api.IBaseIntegerDatatype;

@DatatypeDef(name="integer")
public class IntegerDt
extends BasePrimitive<Integer>
implements IBaseIntegerDatatype {
    public IntegerDt() {
    }

    @SimpleSetter
    public IntegerDt(@SimpleSetter.Parameter(name="theInteger") int theInteger) {
        this.setValue((Object)theInteger);
    }

    public IntegerDt(String theIntegerAsString) {
        this.setValueAsString(theIntegerAsString);
    }

    @Override
    protected Integer parse(String theValue) {
        try {
            return Integer.parseInt(theValue);
        }
        catch (NumberFormatException e) {
            throw new DataFormatException(Msg.code(1873) + e);
        }
    }

    @Override
    protected String encode(Integer theValue) {
        return Integer.toString(theValue);
    }
}

