/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.api;

import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public enum Pointcut {
    INTERCEPTOR_REGISTERED(Void.TYPE, new String[0]),
    CLIENT_REQUEST(Void.TYPE, "ca.uhn.fhir.rest.client.api.IHttpRequest", "ca.uhn.fhir.rest.client.api.IRestfulClient"),
    CLIENT_RESPONSE(Void.TYPE, "ca.uhn.fhir.rest.client.api.IHttpRequest", "ca.uhn.fhir.rest.client.api.IHttpResponse", "ca.uhn.fhir.rest.client.api.IRestfulClient"),
    SERVER_INCOMING_REQUEST_PRE_PROCESSED(Boolean.TYPE, "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"),
    SERVER_HANDLE_EXCEPTION(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse", "ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException"),
    SERVER_INCOMING_REQUEST_POST_PROCESSED(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"),
    SERVER_INCOMING_REQUEST_PRE_HANDLED(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.RestOperationTypeEnum", "ca.uhn.fhir.rest.server.interceptor.IServerInterceptor$ActionRequestDetails"),
    SERVER_PRE_PROCESS_OUTGOING_EXCEPTION(BaseServerResponseException.class, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "java.lang.Throwable", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"),
    SERVER_OUTGOING_RESPONSE(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.ResponseDetails", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"),
    SERVER_OUTGOING_WRITER_CREATED(Writer.class, "java.io.Writer", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    SERVER_OUTGOING_GRAPHQL_RESPONSE(Boolean.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "java.lang.String", "java.lang.String", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"),
    SERVER_OUTGOING_FAILURE_OPERATIONOUTCOME(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "org.hl7.fhir.instance.model.api.IBaseOperationOutcome"),
    SERVER_PROCESSING_COMPLETED_NORMALLY(Void.TYPE, new ExceptionHandlingSpec().addLogAndSwallow(Throwable.class), "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    SERVER_PROCESSING_COMPLETED(Void.TYPE, new ExceptionHandlingSpec().addLogAndSwallow(Throwable.class), "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    SUBSCRIPTION_RESOURCE_MODIFIED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_RESOURCE_MATCHED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage", "ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult"),
    SUBSCRIPTION_RESOURCE_DID_NOT_MATCH_ANY_SUBSCRIPTIONS(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_BEFORE_DELIVERY(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_AFTER_DELIVERY(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_AFTER_DELIVERY_FAILED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage", "java.lang.Exception"),
    SUBSCRIPTION_AFTER_REST_HOOK_DELIVERY(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_BEFORE_REST_HOOK_DELIVERY(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_AFTER_MESSAGE_DELIVERY(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_BEFORE_MESSAGE_DELIVERY(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription", "ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage"),
    SUBSCRIPTION_BEFORE_PERSISTED_RESOURCE_CHECKED(Boolean.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_AFTER_PERSISTED_RESOURCE_CHECKED(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage"),
    SUBSCRIPTION_AFTER_ACTIVE_SUBSCRIPTION_REGISTERED(Void.TYPE, "ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription"),
    SUBSCRIPTION_AFTER_ACTIVE_SUBSCRIPTION_UNREGISTERED(Void.TYPE, new String[0]),
    STORAGE_CASCADE_DELETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.api.model.DeleteConflictList", "org.hl7.fhir.instance.model.api.IBaseResource"),
    STORAGE_PRE_DELETE_EXPUNGE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "java.lang.String"),
    STORAGE_PRE_DELETE_EXPUNGE_PID_LIST(Void.TYPE, "java.lang.String", "java.util.List", "java.util.concurrent.atomic.AtomicLong", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PREACCESS_RESOURCES(Void.TYPE, "ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRECHECK_FOR_CACHED_SEARCH(Boolean.TYPE, "ca.uhn.fhir.jpa.searchparam.SearchParameterMap", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRESEARCH_REGISTERED(Void.TYPE, "ca.uhn.fhir.rest.server.util.ICachedSearchDetails", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRESHOW_RESOURCES(Void.TYPE, "ca.uhn.fhir.rest.api.server.IPreResourceShowDetails", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRESTORAGE_RESOURCE_CREATED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRESTORAGE_RESOURCE_UPDATED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRESTORAGE_RESOURCE_DELETED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRECOMMIT_RESOURCE_CREATED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRECOMMIT_RESOURCE_UPDATED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRECOMMIT_RESOURCE_DELETED(Void.TYPE, "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRESTORAGE_DELETE_CONFLICTS("ca.uhn.fhir.jpa.delete.DeleteConflictOutcome", "ca.uhn.fhir.jpa.api.model.DeleteConflictList", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.rest.api.server.storage.TransactionDetails"),
    STORAGE_PRESTORAGE_EXPUNGE_RESOURCE(Void.TYPE, "java.util.concurrent.atomic.AtomicInteger", "org.hl7.fhir.instance.model.api.IIdType", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PRESTORAGE_EXPUNGE_EVERYTHING(Void.TYPE, "java.util.concurrent.atomic.AtomicInteger", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PARTITION_IDENTIFY_CREATE("ca.uhn.fhir.interceptor.model.RequestPartitionId", "org.hl7.fhir.instance.model.api.IBaseResource", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PARTITION_IDENTIFY_READ("ca.uhn.fhir.interceptor.model.RequestPartitionId", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_PARTITION_SELECTED(Void.TYPE, "ca.uhn.fhir.interceptor.model.RequestPartitionId", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    STORAGE_VERSION_CONFLICT("ca.uhn.fhir.jpa.api.model.ResourceVersionConflictResolutionStrategy", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    EMPI_AFTER_PERSISTED_RESOURCE_CHECKED(Void.TYPE, "ca.uhn.fhir.rest.server.messaging.ResourceOperationMessage", "ca.uhn.fhir.rest.server.TransactionLogMessages"),
    JPA_PERFTRACE_INFO(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.StorageProcessingMessage"),
    JPA_PERFTRACE_WARNING(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.StorageProcessingMessage"),
    JPA_PERFTRACE_SEARCH_FIRST_RESULT_LOADED(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_SELECT_COMPLETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_FAILED(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_PASS_COMPLETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_INDEXSEARCH_QUERY_COMPLETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_REUSING_CACHED(Boolean.TYPE, "ca.uhn.fhir.jpa.searchparam.SearchParameterMap", "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails"),
    JPA_PERFTRACE_SEARCH_COMPLETE(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails"),
    JPA_PERFTRACE_SEARCH_FOUND_ID(Void.TYPE, "java.lang.Integer", "java.lang.Object"),
    JPA_PERFTRACE_RAW_SQL(Void.TYPE, "ca.uhn.fhir.rest.api.server.RequestDetails", "ca.uhn.fhir.rest.server.servlet.ServletRequestDetails", "ca.uhn.fhir.jpa.util.SqlQueryList"),
    TEST_RB(Boolean.TYPE, new ExceptionHandlingSpec().addLogAndSwallow(IllegalStateException.class), String.class.getName(), String.class.getName()),
    TEST_RO(BaseServerResponseException.class, String.class.getName(), String.class.getName());

    private final List<String> myParameterTypes;
    private final Class<?> myReturnType;
    private final ExceptionHandlingSpec myExceptionHandlingSpec;

    private Pointcut(String theReturnType, String ... theParameterTypes) {
        this(Pointcut.toReturnTypeClass(theReturnType), new ExceptionHandlingSpec(), theParameterTypes);
    }

    private Pointcut(Class<?> theReturnType, ExceptionHandlingSpec theExceptionHandlingSpec, String ... theParameterTypes) {
        this.myReturnType = theReturnType;
        this.myExceptionHandlingSpec = theExceptionHandlingSpec;
        this.myParameterTypes = Collections.unmodifiableList(Arrays.asList(theParameterTypes));
    }

    private Pointcut(Class<?> theReturnType, String ... theParameterTypes) {
        this(theReturnType, new ExceptionHandlingSpec(), theParameterTypes);
    }

    public boolean isShouldLogAndSwallowException(@Nonnull Throwable theException) {
        for (Class next : this.myExceptionHandlingSpec.myTypesToLogAndSwallow) {
            if (!next.isAssignableFrom(theException.getClass())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Class<?> getReturnType() {
        return this.myReturnType;
    }

    @Nonnull
    public List<String> getParameterTypes() {
        return this.myParameterTypes;
    }

    private static Class<?> toReturnTypeClass(String theReturnType) {
        try {
            return Class.forName(theReturnType);
        }
        catch (ClassNotFoundException theE) {
            return UnknownType.class;
        }
    }

    private static class ExceptionHandlingSpec {
        private final Set<Class<? extends Throwable>> myTypesToLogAndSwallow = new HashSet<Class<? extends Throwable>>();

        private ExceptionHandlingSpec() {
        }

        ExceptionHandlingSpec addLogAndSwallow(@Nonnull Class<? extends Throwable> theType) {
            this.myTypesToLogAndSwallow.add(theType);
            return this;
        }
    }

    private static class UnknownType {
        private UnknownType() {
        }
    }
}

