/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.pdfa;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;

public class PDFXMPHelper {
    public static void main(String[] args) throws IOException, DocumentException {
        PDFXMPHelper.setXmpMetadata("target/rendition.pdf", "target/renditionFINAL.pdf", FileUtils.readFileToByteArray((File)new File("src/test/resources/metadata.txt")));
    }

    public static void setXmpMetadata(String sourceFileName, String toFileName, byte[] xmp) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(sourceFileName);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(toFileName));
        PDFXMPHelper.createPDFWithXmpMetadata(stamper, xmp);
        stamper.close();
    }

    public static void createPDFWithXmpMetadata(OutputStream out, InputStream inputStream, byte[] xmp) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(inputStream);
        PdfStamper stamper = new PdfStamper(reader, out);
        PDFXMPHelper.createPDFWithXmpMetadata(stamper, xmp);
        stamper.close();
    }

    public static PdfStamper createPDFWithXmpMetadata(PdfStamper stamper, byte[] xmp) throws IOException, DocumentException {
        stamper.setXmpMetadata(xmp);
        return stamper;
    }
}

