/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.pdfa;

import br.gov.lexml.pdfa.PDFAttachmentFile;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfAStamper;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PDFAttachmentHelper {
    private static final PdfName AF_KEY = new PdfName("AF");

    public static void main(String[] args) throws IOException, DocumentException {
        PDFAttachmentFile f = new PDFAttachmentFile(new File("src/main/resources/madoc.jpeg"), "madoc.jpeg", "image/jpeg", "2012/01/01T01:01-02:00", PDFAttachmentFile.AFRelationShip.SOURCE);
        ArrayList<PDFAttachmentFile> listAttachments = new ArrayList<PDFAttachmentFile>();
        listAttachments.add(f);
        PDFAttachmentHelper.addAttachmentsToPDF(new FileInputStream("target/rendition.pdf"), new FileOutputStream("target/rendition-a3.pdf"), listAttachments, PdfAConformanceLevel.PDF_A_3B);
        System.out.println("Pronto!");
    }

    public static void addAttachmentsToPDF(InputStream pdfSource, OutputStream dest, List<PDFAttachmentFile> files, PdfAConformanceLevel conformanceLevel) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(pdfSource);
        PdfAStamper stamper = new PdfAStamper(reader, dest, conformanceLevel);
        List<PdfFileSpecification> pfs = PDFAttachmentHelper.addAttachmentsToPdfWriter(stamper.getWriter(), files);
        PDFAttachmentHelper.addAFEntry(stamper.getWriter(), pfs);
        stamper.close();
    }

    public static List<PdfFileSpecification> addAttachmentsToPdfWriter(PdfWriter writer, List<PDFAttachmentFile> files) throws IOException, DocumentException {
        ArrayList<PdfFileSpecification> pdfFileSpecificationList = new ArrayList<PdfFileSpecification>();
        for (PDFAttachmentFile f : files) {
            pdfFileSpecificationList.add(PDFAttachmentHelper.addAttachment(writer, f));
        }
        return pdfFileSpecificationList;
    }

    protected static void addAFEntry(PdfWriter writer, List<PdfFileSpecification> pdfFileSpecificationList) throws IOException {
        PDFAttachmentHelper.addAFEntry(writer.getExtraCatalog(), pdfFileSpecificationList);
    }

    protected static void addAFEntry(PdfDictionary catalog, List<PdfFileSpecification> pdfFileSpecificationList) throws IOException {
        PdfArray pdfArray = catalog.getAsArray(AF_KEY);
        if (pdfArray == null) {
            pdfArray = new PdfArray();
        }
        for (PdfFileSpecification pfs : pdfFileSpecificationList) {
            pdfArray.add((PdfObject)pfs.getReference());
        }
        catalog.put(AF_KEY, (PdfObject)pdfArray);
    }

    protected static PdfFileSpecification addAttachment(PdfWriter writer, PDFAttachmentFile file) throws IOException {
        PdfDictionary fileParameter = new PdfDictionary();
        fileParameter.put(new PdfName("ModDate"), (PdfObject)new PdfString(file.getDateTime()));
        PdfFileSpecification fs = PdfFileSpecification.fileEmbedded((PdfWriter)writer, (String)(file.getFile() == null ? null : file.getFile().getAbsolutePath()), (String)file.getFileName(), (byte[])file.getFileStore(), (boolean)false, (String)file.getMimeType(), (PdfDictionary)fileParameter);
        fs.put(new PdfName("AFRelationship"), (PdfObject)new PdfName(file.getAfRelationshipValue()));
        writer.addFileAttachment(file.getFileName(), fs);
        return fs;
    }

    public static void extractAttachments(String src, String dir) throws IOException {
        File folder = new File(dir);
        folder.mkdirs();
        PdfReader reader = new PdfReader(src);
        PdfDictionary root = reader.getCatalog();
        PdfDictionary names = root.getAsDict(PdfName.NAMES);
        PdfDictionary embedded = names.getAsDict(PdfName.EMBEDDEDFILES);
        PdfArray filespecs = embedded.getAsArray(PdfName.NAMES);
        int i = 0;
        while (i < filespecs.size()) {
            PDFAttachmentHelper.extractAttachment(reader, folder, filespecs.getAsString(i++), filespecs.getAsDict(i++));
        }
    }

    protected static void extractAttachment(PdfReader reader, File dir, PdfString name, PdfDictionary filespec) throws IOException {
        PdfDictionary refs = filespec.getAsDict(PdfName.EF);
        for (PdfName key : refs.getKeys()) {
            PRStream stream = (PRStream)PdfReader.getPdfObject((PdfObject)refs.getAsIndirectObject(key));
            String filename = filespec.getAsString(key).toString();
            FileOutputStream fos = new FileOutputStream(new File(dir, filename));
            fos.write(PdfReader.getStreamBytes((PRStream)stream));
            fos.flush();
            fos.close();
        }
    }

    public static void removeAttachments(PdfReader reader) {
        PdfDictionary files;
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject((PdfObject)catalog.get(PdfName.NAMES));
        if (names != null && (files = (PdfDictionary)PdfReader.getPdfObject((PdfObject)names.get(PdfName.EMBEDDEDFILES))) != null) {
            for (Object key : files.getKeys()) {
                files.remove((PdfName)key);
            }
            reader.removeUnusedObjects();
        }
    }
}

