/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.pdfa;

import br.gov.lexml.pdfa.PDFAttachmentFile;
import br.gov.lexml.pdfa.PDFAttachmentHelper;
import br.gov.lexml.pdfa.PDFXMPHelper;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfAStamper;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class PDFA {
    private final PdfAStamper stamper;
    private final PdfReader reader;
    private final PdfAConformanceLevel conformanceLevel;

    private PDFA(PdfReader reader, PdfAStamper stamper, PdfAConformanceLevel conformanceLevel) {
        this.reader = reader;
        this.stamper = stamper;
        this.conformanceLevel = conformanceLevel;
    }

    public static PDFA getNewInstance(OutputStream pdfDest, InputStream pdfSource, String part, String conformance) throws Exception {
        return PDFA.getNewInstance(pdfDest, pdfSource, PDFConformance.getPDFConformance(part, conformance));
    }

    private static PDFA getNewInstance(OutputStream pdfDest, InputStream pdfSource, PDFConformance conformance) throws Exception {
        PdfAConformanceLevel c = conformance.getConformanceLevel();
        if (c == null) {
            return null;
        }
        PdfReader reader = new PdfReader(pdfSource);
        PdfAStamper stamper = new PdfAStamper(reader, pdfDest, c);
        return new PDFA(reader, stamper, c);
    }

    public PdfAStamper getStamper() {
        return this.stamper;
    }

    public void setVersion(PDFVersion pdfVersion) {
        PdfWriter writer = this.stamper.getWriter();
        writer.setPdfVersion(pdfVersion.getPdfNameVersion());
    }

    public PDFA addXMP(byte[] xmp) throws Exception {
        PDFXMPHelper.createPDFWithXmpMetadata((PdfStamper)this.getStamper(), xmp);
        return this;
    }

    public PDFA addAttachment(PDFAttachmentFile file) throws Exception {
        return this.addAttachments(file);
    }

    public PDFA addAttachments(PDFAttachmentFile ... files) throws Exception {
        return this.addAttachments(Arrays.asList(files));
    }

    public PDFA addAttachments(List<PDFAttachmentFile> files) throws Exception {
        PdfWriter writer = this.getStamper().getWriter();
        List<PdfFileSpecification> pfs = PDFAttachmentHelper.addAttachmentsToPdfWriter(writer, files);
        if (this.conformanceLevel == PdfAConformanceLevel.PDF_A_3A || this.conformanceLevel == PdfAConformanceLevel.PDF_A_3B) {
            PDFAttachmentHelper.addAFEntry(this.reader.getCatalog(), pfs);
        }
        return this;
    }

    public void close() throws Exception {
        this.getStamper().close();
    }

    public static enum PDFConformance {
        PDF_A_1A(PdfAConformanceLevel.PDF_A_1A, "1", "A"),
        PDF_A_1B(PdfAConformanceLevel.PDF_A_1B, "1", "B"),
        PDF_A_2A(PdfAConformanceLevel.PDF_A_2A, "2", "A"),
        PDF_A_2B(PdfAConformanceLevel.PDF_A_2B, "2", "B"),
        PDF_A_3A(PdfAConformanceLevel.PDF_A_3A, "3", "A"),
        PDF_A_3B(PdfAConformanceLevel.PDF_A_3B, "3", "B");

        private final PdfAConformanceLevel conformanceLevel;
        private final String part;
        private final String conformance;

        private PDFConformance(PdfAConformanceLevel conformanceLevel, String part, String conformance) {
            this.conformanceLevel = conformanceLevel;
            this.part = part;
            this.conformance = conformance;
        }

        public PdfAConformanceLevel getConformanceLevel() {
            return this.conformanceLevel;
        }

        public String getConformance() {
            return this.conformance;
        }

        public String getPart() {
            return this.part;
        }

        public static PDFConformance getPDFConformance(String part, String conformance) {
            for (PDFConformance c : Arrays.asList(PDFConformance.values())) {
                if (!c.getPart().equals(part) || !c.getConformance().equals(conformance)) continue;
                return c;
            }
            return null;
        }
    }

    public static enum PDFVersion {
        PDF_VERSION_1_2(PdfWriter.PDF_VERSION_1_2),
        PDF_VERSION_1_3(PdfWriter.PDF_VERSION_1_3),
        PDF_VERSION_1_4(PdfWriter.PDF_VERSION_1_4),
        PDF_VERSION_1_5(PdfWriter.PDF_VERSION_1_5),
        PDF_VERSION_1_6(PdfWriter.PDF_VERSION_1_6),
        PDF_VERSION_1_7(PdfWriter.PDF_VERSION_1_7);

        private PdfName pdfNameVersion;

        private PDFVersion(PdfName pdfNameVersion) {
            this.pdfNameVersion = pdfNameVersion;
        }

        public PdfName getPdfNameVersion() {
            return this.pdfNameVersion;
        }
    }
}

