/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.schema.validator;

import br.gov.lexml.schema.validator.ResultadoValidacao;
import br.gov.lexml.schema.validator.TipoSchema;
import br.gov.lexml.schema.validator.ValidadorException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class Validador {
    private static final Logger logger = LoggerFactory.getLogger(Validador.class);
    private static final String UTF_8 = "utf-8";
    private static Validador instance = null;
    private final LSResourceResolver resourceResolver;
    private final Map<TipoSchema, Schema> schemas = new EnumMap<TipoSchema, Schema>(TipoSchema.class);

    public static synchronized Validador getInstance() throws ValidadorException {
        if (instance == null) {
            instance = new Validador();
        }
        return instance;
    }

    private void readSchema(SchemaFactory sf, TipoSchema tipo, String fileName) throws ValidadorException {
        logger.info("readSchema: fileName: {}", (Object)fileName);
        try {
            InputStream is = Validador.getResourceAsStream(fileName);
            if (is == null) {
                throw new ValidadorException("Nao foi possivel localizar recurso: " + fileName);
            }
            this.schemas.put(tipo, sf.newSchema(new StreamSource(is)));
        }
        catch (SAXException e) {
            throw new ValidadorException("Erro durante a leitura do schema " + fileName, e);
        }
    }

    private Validador() throws ValidadorException {
        MyXMLResolver resolver = new MyXMLResolver();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", true);
        inputFactory.setProperty("javax.xml.stream.resolver", resolver);
        this.resourceResolver = new MyLSResourceResolver();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setResourceResolver(this.resourceResolver);
        this.readSchema(sf, TipoSchema.RIGIDO, "xsd/lexml-br-rigido.xsd");
        this.readSchema(sf, TipoSchema.FLEXIVEL, "xsd/lexml-flexivel.xsd");
        this.readSchema(sf, TipoSchema.OAI, "xsd/oai_lexml.xsd");
        this.readSchema(sf, TipoSchema.EMENDA, "xsd/lexml-emenda-proposicao.xsd");
    }

    private static InputStream getResourceAsStream(String resource) {
        logger.info("Validador.getResourceAsStream: resource = {}", (Object)resource);
        ClassLoader cl = Validador.class.getClassLoader();
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            logger.info("classloader urls: {}", Arrays.asList(ucl.getURLs()));
        } else {
            logger.info("classloader class: {}", (Object)cl.getClass().getName());
        }
        return cl.getResourceAsStream(resource);
    }

    private ResultadoValidacao valide(TipoSchema tipoSchema, Source source) throws IOException {
        ResultadoValidacao res = new ResultadoValidacao();
        Schema schema = this.schemas.get((Object)tipoSchema);
        Validator validator = schema.newValidator();
        validator.setErrorHandler(res);
        validator.setResourceResolver(this.resourceResolver);
        try {
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
        return res;
    }

    private ResultadoValidacao valide(TipoSchema tipoSchema, Reader fonte) throws IOException {
        return this.valide(tipoSchema, new StreamSource(fonte));
    }

    public ResultadoValidacao valide(TipoSchema tipoSchema, char[] fonte) throws IOException {
        return this.valide(tipoSchema, new CharArrayReader(fonte));
    }

    public ResultadoValidacao valide(TipoSchema tipoSchema, String fonte) throws IOException {
        return this.valide(tipoSchema, new StreamSource(new StringReader(fonte)));
    }

    private ResultadoValidacao valide(TipoSchema tipoSchema, InputStream fonte) throws IOException {
        return this.valide(tipoSchema, new StreamSource(fonte, UTF_8));
    }

    public ResultadoValidacao valide(TipoSchema tipoSchema, byte[] fonte) throws IOException {
        return this.valide(tipoSchema, new ByteArrayInputStream(fonte));
    }

    public ResultadoValidacao valide(TipoSchema tipoSchema, String resourceName, Class<?> clazz) throws IOException {
        return this.valide(tipoSchema, clazz.getResourceAsStream(resourceName));
    }

    public ResultadoValidacao valide(TipoSchema tipoSchema, String resourceName, ClassLoader loader) throws IOException {
        return this.valide(tipoSchema, loader.getResourceAsStream(resourceName));
    }

    private class MyXMLResolver
    implements XMLResolver {
        private MyXMLResolver() {
        }

        @Override
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
            logger.info("MyXMLResolver.resolveEntity: resolving {}", (Object)systemID);
            return Validador.getResourceAsStream(systemID);
        }
    }

    private class MyLSResourceResolver
    implements LSResourceResolver {
        private final Logger logger = LoggerFactory.getLogger(MyLSResourceResolver.class);

        private MyLSResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, final String publicId, final String systemId, final String baseURI) {
            this.logger.info("MyLSResolver.resolveEntity: resolving namespaceURI: {}, systemId: {}, baseURI: {}", new Object[]{namespaceURI, systemId, baseURI});
            final String resourceName = this.resolveResourceName(namespaceURI, systemId, baseURI);
            if (resourceName == null) {
                this.logger.error("resolveResource: cannot resolve {}", (Object)namespaceURI);
                return null;
            }
            this.logger.info("resolveResource: resolved {} to {}", (Object)namespaceURI, (Object)resourceName);
            return new LSInput(){

                @Override
                public Reader getCharacterStream() {
                    MyLSResourceResolver.this.logger.info("getCharacterStream");
                    return new BufferedReader(new InputStreamReader(Validador.getResourceAsStream("xsd/" + resourceName)));
                }

                @Override
                public void setCharacterStream(Reader characterStream) {
                    throw new UnsupportedOperationException("unexpected method call: setCharacterStream");
                }

                @Override
                public InputStream getByteStream() {
                    return null;
                }

                @Override
                public void setByteStream(InputStream byteStream) {
                    throw new UnsupportedOperationException("unexpected method call: setByteStream");
                }

                @Override
                public String getStringData() {
                    return null;
                }

                @Override
                public void setStringData(String stringData) {
                    throw new UnsupportedOperationException("unexpected method call: setStringData");
                }

                @Override
                public String getSystemId() {
                    return systemId;
                }

                @Override
                public void setSystemId(String systemId2) {
                    throw new UnsupportedOperationException("unexpected method call: setSystemId");
                }

                @Override
                public String getPublicId() {
                    return publicId;
                }

                @Override
                public void setPublicId(String publicId2) {
                    throw new UnsupportedOperationException("unexpected method call: setPublicId");
                }

                @Override
                public String getBaseURI() {
                    return baseURI;
                }

                @Override
                public void setBaseURI(String baseURI2) {
                    throw new UnsupportedOperationException("unexpected method call: setBaseURI");
                }

                @Override
                public String getEncoding() {
                    return Validador.UTF_8;
                }

                @Override
                public void setEncoding(String encoding) {
                    throw new UnsupportedOperationException("unexpected method call: setEncoding");
                }

                @Override
                public boolean getCertifiedText() {
                    return false;
                }

                @Override
                public void setCertifiedText(boolean certifiedText) {
                    throw new UnsupportedOperationException("unexpected method call: setCertifiedText");
                }
            };
        }

        private String resolveResourceName(String namespaceURI, String systemId, String baseURI) {
            Object res = baseURI != null && baseURI.endsWith("//www.w3.org/Math/XMLSchema/mathml2/mathml2.xsd") ? "mathml2/" + systemId : (systemId != null && systemId.contains("mathml2") ? systemId.replaceFirst("^.*mathml2/", "mathml2/") : (systemId != null ? systemId.replaceFirst("^.*/", "") : null));
            this.logger.info("resolverResourceName: namespaceURI = {}, systemId = {}, baseURI = {}, res = {}", new Object[]{namespaceURI, systemId, baseURI, res});
            return res;
        }
    }
}

