/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import br.gov.lexml.eta.etaservices.printing.pdf.HTML2FOConverter;
import br.gov.lexml.eta.etaservices.printing.pdf.VelocityExtensionUtils;
import com.itextpdf.text.pdf.codec.Base64;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityExtension {
    private static final int MAX_IMAGE_WIDTH = 800;
    private static final Logger log = LoggerFactory.getLogger(VelocityExtension.class);
    private HTML2FOConverter html2foConverter;
    private VelocityContext ctx;
    private VelocityEngine velocityEngine;

    public VelocityExtension(VelocityContext ctx, VelocityEngine velocityEngine) {
        try {
            this.ctx = ctx;
            this.velocityEngine = velocityEngine;
            this.html2foConverter = new HTML2FOConverter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String html2fo(String html) {
        try {
            String fo = this.html2foConverter.html2fo(StringEscapeUtils.unescapeHtml4((String)html));
            return VelocityExtensionUtils.render(fo, this.ctx, this.velocityEngine);
        }
        catch (Exception e) {
            log.error("Falha na convers\u00e3o para FO", (Throwable)e);
            return e.getLocalizedMessage();
        }
    }

    public String html2foTextoLivre(String html) {
        html = this.trataImagens(html);
        html = this.addStyle(html, "(p|ol|ul)", "margin-bottom: $pMarginBottom");
        html = this.multipleReplaceAll(html, "<[^>]+class=\"[^\"]*ql-margin-bottom-0px.+?>", m -> Matcher.quoteReplacement(m.group().replace("$pMarginBottom", "0")));
        html = this.multipleReplaceAll(html, "<table .+?</table>", m -> Matcher.quoteReplacement(m.group().replace("$pMarginBottom", "0")));
        html = html.replaceAll("<del .+?</del>", "").replaceAll("<ins .*?>", "").replace("</ins>", "");
        String htmlAttrFo = html.replaceAll("<p(.+?)><img", "<p$1 class=\"align-center\"><img").replaceAll("(class=\"[^\"]*)estilo-ementa", "margin-left=\"6.5cm\" text-indent=\"0\" $1").replaceAll("(class=\"[^\"]*)estilo-norma-alterada", "margin-left=\"3cm\" text-indent=\"1.5cm\" $1").replaceAll("(class=\"[^\"]*)ql-text-indent-0px", "text-indent=\"0\" $1").replaceAll("texto=\".*?\"", "");
        return this.html2fo(htmlAttrFo);
    }

    private String trataImagens(String html) {
        return this.multipleReplaceAll(html, "<img .+?>", m -> {
            String tag = m.group();
            Matcher mSrc = Pattern.compile("src=\"data:image/(.+?);base64,(.+?)\"").matcher(tag);
            if (mSrc.find()) {
                try {
                    String imageType = mSrc.group(1);
                    byte[] bytes = Base64.decode((String)mSrc.group(2));
                    boolean isPng = imageType.equals("png");
                    String extension = isPng ? ".png" : ".jpeg";
                    File f = File.createTempFile("imagem-", extension);
                    if (isPng) {
                        FileUtils.writeByteArrayToFile((File)f, (byte[])bytes);
                    } else {
                        BufferedImage image = ImageIO.read(new ByteArrayInputStream(bytes));
                        ImageIO.write((RenderedImage)image, "JPG", f);
                    }
                    return tag.replaceAll("src=\".+?\"", "src=\"file:" + f.getAbsolutePath() + "\"");
                }
                catch (Exception e) {
                    log.error("Falha ao tratar imagem para o PDF.", (Throwable)e);
                    return html;
                }
            }
            return html;
        });
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
        Image resultingImage = originalImage.getScaledInstance(targetWidth, targetHeight, 1);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 1);
        outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
        return outputImage;
    }

    public String citacao2html(String citacao) {
        citacao = citacao.replace("Rotulo>", "strong>").replace("<Alteracao>", "<div margin-left=\"3cm\" text-indent=\"1.5cm\">").replace("</Alteracao>", "</div>").replaceAll("(?i)<omissis ?/>", "<span class=\"omissis\"></span>").replaceAll("(class=\"[^\"]*)agrupador", "align=\"center\" text-indent=\"0\" $1").replaceAll("(class=\"[^\"]*)(?:sub)?secao", "font-weight=\"bold\" $1").replace("class=\"ementa", "style=\"margin-left: 40%; text-indent: 0\"");
        return citacao;
    }

    public int size(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length;
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        return o.toString().length();
    }

    public boolean isEmpty(Object o) {
        return this.size(o) == 0;
    }

    public String addStyle(String html, String tagName, String style) {
        StringBuffer sb = new StringBuffer();
        Pattern tagPattern = Pattern.compile("<" + tagName + "\\b.*?>", 34);
        Matcher mTag = tagPattern.matcher(html);
        while (mTag.find()) {
            String tag = mTag.group();
            tag = tag.contains("style=\"") ? tag.replace("style=\"", "style=\"" + style + ";") : tag.replace(">", " style=\"" + style + "\">");
            mTag.appendReplacement(sb, Matcher.quoteReplacement(tag));
        }
        mTag.appendTail(sb);
        return sb.toString();
    }

    public String getDataIso() {
        return LocalDateTime.now().atOffset(ZoneOffset.ofHours(-3)).toString();
    }

    private String multipleReplaceAll(String str, String pattern, Function<Matcher, String> replacer) {
        StringBuilder sb = new StringBuilder();
        Matcher m = Pattern.compile(pattern).matcher(str);
        while (m.find()) {
            m.appendReplacement(sb, replacer.apply(m));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

