/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.emenda;

import br.gov.lexml.eta.etaservices.emenda.ColegiadoAutor;
import br.gov.lexml.eta.etaservices.emenda.Parlamentar;
import br.gov.lexml.eta.etaservices.emenda.TipoAutoria;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public interface Autoria {
    public TipoAutoria getTipo();

    public boolean isImprimirPartidoUF();

    public int getQuantidadeAssinaturasAdicionaisSenadores();

    @JsonIgnore
    default public int[] getAssinaturasAdicionaisSenadores() {
        return IntStream.range(0, this.getQuantidadeAssinaturasAdicionaisSenadores()).toArray();
    }

    public int getQuantidadeAssinaturasAdicionaisDeputados();

    @JsonIgnore
    default public int[] getAssinaturasAdicionaisDeputados() {
        return IntStream.range(0, this.getQuantidadeAssinaturasAdicionaisDeputados()).toArray();
    }

    public List<? extends Parlamentar> getParlamentares();

    @JsonIgnore
    default public List<Parlamentar[]> getParlamentaresPair() {
        ArrayList<Parlamentar[]> result = new ArrayList<Parlamentar[]>();
        int listSize = this.getParlamentares().size();
        for (int i = 0; i < listSize; i += 2) {
            if (listSize == i + 1) {
                result.add(new Parlamentar[]{this.getParlamentares().get(i), null});
                continue;
            }
            result.add(new Parlamentar[]{this.getParlamentares().get(i), this.getParlamentares().get(i + 1)});
        }
        return result;
    }

    public ColegiadoAutor getColegiado();
}

