/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import br.gov.lexml.eta.etaservices.printing.pdf.FOPProcessor;
import br.gov.lexml.eta.etaservices.printing.pdf.TemplateLoaderBean;
import br.gov.lexml.eta.etaservices.printing.pdf.VelocityTemplateProcessor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class TesteGeracaoPDF {
    public static final String EMENDA_XML = "<emenda>Teste</emenda>";
    private static final String TARGET_FO_EMENDA_XML = "target/fo-emenda.xml";
    private static final String TARGET_EMENDA_PDF = "target/emenda.pdf";

    public static void main(String[] args) throws IOException {
        TesteGeracaoPDF.processaVelocity();
        TesteGeracaoPDF.processaFOEmenda();
    }

    private static void processaVelocity() throws IOException {
        String fo = new VelocityTemplateProcessor(new TemplateLoaderBean()).getTemplateResult(null);
        FileUtils.writeStringToFile((File)new File(TARGET_FO_EMENDA_XML), (String)fo, (Charset)StandardCharsets.UTF_8);
    }

    private static void processaFOEmenda() throws IOException {
        try (OutputStream out = Files.newOutputStream(Paths.get(TARGET_EMENDA_PDF, new String[0]), new OpenOption[0]);){
            String xslFo = FileUtils.readFileToString((File)new File(TARGET_FO_EMENDA_XML), (Charset)StandardCharsets.UTF_8);
            new FOPProcessor().processFOP(out, xslFo, EMENDA_XML);
        }
    }
}

