/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;

public class SMIMEUtil {
    static boolean isCanonicalisationRequired(Part part, String string) throws MessagingException {
        if (part instanceof MimeBodyPart) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)part;
            String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
            String string2 = stringArray == null ? string : stringArray[0];
            return !string2.equalsIgnoreCase("binary");
        }
        return !string.equalsIgnoreCase("binary");
    }

    public static MimeBodyPart toMimeBodyPart(byte[] byArray) throws SMIMEException {
        return SMIMEUtil.toMimeBodyPart(new ByteArrayInputStream(byArray));
    }

    public static MimeBodyPart toMimeBodyPart(InputStream inputStream) throws SMIMEException {
        try {
            return new MimeBodyPart(inputStream);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception creating body part.", (Exception)((Object)messagingException));
        }
    }

    public static FileBackedMimeBodyPart toMimeBodyPart(CMSTypedStream cMSTypedStream) throws SMIMEException {
        try {
            return SMIMEUtil.toMimeBodyPart(cMSTypedStream, File.createTempFile("bcMail", ".mime"));
        }
        catch (IOException iOException) {
            throw new SMIMEException("IOException creating tmp file:" + iOException.getMessage());
        }
    }

    public static FileBackedMimeBodyPart toMimeBodyPart(CMSTypedStream cMSTypedStream, File file) throws SMIMEException {
        try {
            SMIMEUtil.saveContentToFile(cMSTypedStream, file);
            return new FileBackedMimeBodyPart(file);
        }
        catch (IOException iOException) {
            throw new SMIMEException("can't save content to file: " + iOException, iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("can't create part: " + (Object)((Object)messagingException), (Exception)((Object)messagingException));
        }
    }

    private static void saveContentToFile(CMSTypedStream cMSTypedStream, File file) throws FileNotFoundException, IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = cMSTypedStream.getContentStream();
        byte[] byArray = new byte[10000];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)fileOutputStream).close();
        inputStream.close();
    }

    public static IssuerAndSerialNumber createIssuerAndSerialNumberFor(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            return new IssuerAndSerialNumber((X509Name)PrincipalUtil.getIssuerX509Principal((X509Certificate)x509Certificate), x509Certificate.getSerialNumber());
        }
        catch (Exception exception) {
            throw new CertificateParsingException("exception extracting issuer and serial number: " + exception);
        }
    }
}

