/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Signatures;
import aQute.bnd.signatures.WildcardIndicator;
import aQute.lib.stringrover.StringRover;
import java.util.Objects;
import java.util.Set;

public class TypeArgument {
    static final TypeArgument[] EMPTY = new TypeArgument[0];
    public final WildcardIndicator wildcard;
    public final ReferenceTypeSignature type;

    public TypeArgument(WildcardIndicator wildcard, ReferenceTypeSignature type) {
        this.wildcard = wildcard;
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.wildcard, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeArgument)) {
            return false;
        }
        TypeArgument other = (TypeArgument)obj;
        return this.wildcard == other.wildcard && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return switch (this.wildcard) {
            case WildcardIndicator.WILD -> "*";
            case WildcardIndicator.EXACT -> this.type.toString();
            case WildcardIndicator.SUPER -> "-" + this.type;
            case WildcardIndicator.EXTENDS -> "+" + this.type;
            default -> this.wildcard.toString() + this.type;
        };
    }

    static TypeArgument parseTypeArgument(StringRover signature) {
        return switch (signature.charAt(0)) {
            case '*' -> {
                signature.increment();
                yield new TypeArgument(WildcardIndicator.WILD, ClassTypeSignature.OBJECT);
            }
            case '+' -> new TypeArgument(WildcardIndicator.EXTENDS, Signatures.parseReferenceTypeSignature(signature.increment()));
            case '-' -> new TypeArgument(WildcardIndicator.SUPER, Signatures.parseReferenceTypeSignature(signature.increment()));
            default -> new TypeArgument(WildcardIndicator.EXACT, Signatures.parseReferenceTypeSignature(signature));
        };
    }

    static void erasedBinaryReferences(TypeArgument[] typeArguments, Set<String> references) {
        for (TypeArgument typeArgument : typeArguments) {
            if (typeArgument.wildcard == WildcardIndicator.WILD) continue;
            Signatures.erasedBinaryReferences(typeArgument.type, references);
        }
    }
}

