/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.AnnotationInfo;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ElementValueInfo {
    public final String name;
    public final Object value;

    public ElementValueInfo(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String toString() {
        return this.name + "=" + ElementValueInfo.toString(this.value);
    }

    static String toString(Object value) {
        String string;
        if (value instanceof Object[]) {
            Object[] array_value = (Object[])value;
            string = Arrays.toString(array_value);
        } else {
            string = value.toString();
        }
        return string;
    }

    static ElementValueInfo read(DataInput in, ConstantPool constant_pool) throws IOException {
        int element_name_index = in.readUnsignedShort();
        Object value = ElementValueInfo.readValue(in, constant_pool);
        return new ElementValueInfo(constant_pool.utf8(element_name_index), value);
    }

    void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        int element_name_index = constant_pool.utf8Info(this.name);
        out.writeShort(element_name_index);
        ElementValueInfo.writeValue(out, constant_pool, this.value);
    }

    int value_length() {
        return 2 + ElementValueInfo.value_length(this.value);
    }

    static Object readValue(DataInput in, ConstantPool constant_pool) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 66: {
                int const_value_index = in.readUnsignedShort();
                Integer const_value = (Integer)constant_pool.entry(const_value_index);
                return const_value.byteValue();
            }
            case 67: {
                int const_value_index = in.readUnsignedShort();
                Integer const_value = (Integer)constant_pool.entry(const_value_index);
                return Character.valueOf((char)const_value.intValue());
            }
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 115: {
                int const_value_index = in.readUnsignedShort();
                return constant_pool.entry(const_value_index);
            }
            case 83: {
                int const_value_index = in.readUnsignedShort();
                Integer const_value = (Integer)constant_pool.entry(const_value_index);
                return const_value.shortValue();
            }
            case 90: {
                int const_value_index = in.readUnsignedShort();
                Integer const_value = (Integer)constant_pool.entry(const_value_index);
                return const_value != 0;
            }
            case 101: {
                return EnumConst.read(in, constant_pool);
            }
            case 99: {
                return ResultConst.read(in, constant_pool);
            }
            case 64: {
                return AnnotationInfo.read(in, constant_pool);
            }
            case 91: {
                int num_values = in.readUnsignedShort();
                Object[] array_value = new Object[num_values];
                for (int i = 0; i < num_values; ++i) {
                    array_value[i] = ElementValueInfo.readValue(in, constant_pool);
                }
                return array_value;
            }
        }
        throw new IOException("Invalid value for Annotation ElementValue tag " + tag);
    }

    static void writeValue(DataOutput out, ConstantPool constant_pool, Object value) throws IOException {
        if (value instanceof Byte) {
            Byte byte_value = (Byte)value;
            out.writeByte(66);
            int const_value_index = constant_pool.integerInfo(byte_value);
            out.writeShort(const_value_index);
        } else if (value instanceof Character) {
            Character character_value = (Character)value;
            out.writeByte(67);
            int const_value_index = constant_pool.integerInfo(character_value);
            out.writeShort(const_value_index);
        } else if (value instanceof Double) {
            Double double_value = (Double)value;
            out.writeByte(68);
            int const_value_index = constant_pool.doubleInfo(double_value);
            out.writeShort(const_value_index);
        } else if (value instanceof Float) {
            Float float_value = (Float)value;
            out.writeByte(70);
            int const_value_index = constant_pool.floatInfo(float_value);
            out.writeShort(const_value_index);
        } else if (value instanceof Integer) {
            Integer integer_value = (Integer)value;
            out.writeByte(73);
            int const_value_index = constant_pool.integerInfo(integer_value);
            out.writeShort(const_value_index);
        } else if (value instanceof Long) {
            Long long_value = (Long)value;
            out.writeByte(74);
            int const_value_index = constant_pool.longInfo(long_value);
            out.writeShort(const_value_index);
        } else if (value instanceof Short) {
            Short short_value = (Short)value;
            out.writeByte(83);
            int const_value_index = constant_pool.integerInfo(short_value);
            out.writeShort(const_value_index);
        } else if (value instanceof Boolean) {
            Boolean boolean_value = (Boolean)value;
            out.writeByte(90);
            int const_value_index = constant_pool.integerInfo(boolean_value);
            out.writeShort(const_value_index);
        } else if (value instanceof String) {
            String string_value = (String)value;
            out.writeByte(115);
            int const_value_index = constant_pool.utf8Info(string_value);
            out.writeShort(const_value_index);
        } else if (value instanceof EnumConst) {
            EnumConst enum_const_value = (EnumConst)value;
            out.writeByte(101);
            enum_const_value.write(out, constant_pool);
        } else if (value instanceof ResultConst) {
            ResultConst class_info = (ResultConst)value;
            out.writeByte(99);
            class_info.write(out, constant_pool);
        } else if (value instanceof AnnotationInfo) {
            AnnotationInfo annotation_value = (AnnotationInfo)value;
            out.writeByte(64);
            annotation_value.write(out, constant_pool);
        } else if (value instanceof Object[]) {
            Object[] array_value = (Object[])value;
            out.writeByte(91);
            out.writeShort(array_value.length);
            for (Object const_value : array_value) {
                ElementValueInfo.writeValue(out, constant_pool, const_value);
            }
        } else {
            throw new IOException("Unknown value type for ElementValueInfo value " + value);
        }
    }

    static int value_length(Object value) {
        int value_length = 1;
        if (value instanceof Byte) {
            value_length += 2;
        } else if (value instanceof Character) {
            value_length += 2;
        } else if (value instanceof Double) {
            value_length += 2;
        } else if (value instanceof Float) {
            value_length += 2;
        } else if (value instanceof Integer) {
            value_length += 2;
        } else if (value instanceof Long) {
            value_length += 2;
        } else if (value instanceof Short) {
            value_length += 2;
        } else if (value instanceof Boolean) {
            value_length += 2;
        } else if (value instanceof String) {
            value_length += 2;
        } else if (value instanceof EnumConst) {
            EnumConst enum_const_value = (EnumConst)value;
            value_length += enum_const_value.value_length();
        } else if (value instanceof ResultConst) {
            ResultConst class_info = (ResultConst)value;
            value_length += class_info.value_length();
        } else if (value instanceof AnnotationInfo) {
            AnnotationInfo annotation_value = (AnnotationInfo)value;
            value_length += annotation_value.value_length();
        } else if (value instanceof Object[]) {
            Object[] array_value = (Object[])value;
            value_length += 2;
            for (Object const_value : array_value) {
                value_length += ElementValueInfo.value_length(const_value);
            }
        }
        return value_length;
    }

    public static class EnumConst {
        public final String type;
        public final String name;

        public EnumConst(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return this.type + "." + this.name;
        }

        static EnumConst read(DataInput in, ConstantPool constant_pool) throws IOException {
            int type_name_index = in.readUnsignedShort();
            int const_name_index = in.readUnsignedShort();
            return new EnumConst(constant_pool.utf8(type_name_index), constant_pool.utf8(const_name_index));
        }

        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            int type_name_index = constant_pool.utf8Info(this.type);
            int const_name_index = constant_pool.utf8Info(this.name);
            out.writeShort(type_name_index);
            out.writeShort(const_name_index);
        }

        int value_length() {
            return 4;
        }
    }

    public static class ResultConst {
        public final String descriptor;

        public ResultConst(String descriptor) {
            this.descriptor = descriptor;
        }

        public String toString() {
            return this.descriptor;
        }

        static ResultConst read(DataInput in, ConstantPool constant_pool) throws IOException {
            int class_index = in.readUnsignedShort();
            return new ResultConst(constant_pool.utf8(class_index));
        }

        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            int class_index = constant_pool.utf8Info(this.descriptor);
            out.writeShort(class_index);
        }

        int value_length() {
            return 2;
        }
    }
}

