/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.store;

import be.ugent.rml.term.Term;

public class Quad
implements Comparable<Quad> {
    private Term subject;
    private Term predicate;
    private Term object;
    private Term graph;

    public Quad(Term subject, Term predicate, Term object, Term graph) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.graph = graph;
    }

    public Quad(Term subject, Term predicate, Term object) {
        this(subject, predicate, object, null);
    }

    public Term getSubject() {
        return this.subject;
    }

    public Term getPredicate() {
        return this.predicate;
    }

    public Term getObject() {
        return this.object;
    }

    public Term getGraph() {
        return this.graph;
    }

    @Override
    public int compareTo(Quad o) {
        int comparison = this.graph == null || o.getGraph() == null ? 0 : (this.graph == null ? -1 : (o.getGraph() == null ? 1 : this.graph.toString().compareTo(o.getGraph().toString())));
        if (comparison == 0) {
            comparison = this.compareTerms(this.subject, o.getSubject());
            if (comparison == 0) {
                comparison = this.compareTerms(this.predicate, o.getPredicate());
                if (comparison == 0) {
                    return this.compareTerms(this.object, o.getObject());
                }
                return comparison;
            }
            return comparison;
        }
        return comparison;
    }

    private int compareTerms(Term t1, Term t2) {
        if (t1 == null || t2 == null) {
            return 0;
        }
        return t1.toString().compareTo(t2.toString());
    }
}

