/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.records.Record;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRecord
extends Record {
    private Row row;
    private Map<String, Cell> header = new HashMap<String, Cell>();

    ExcelRecord(Row header, Row row) {
        for (Cell cell : header) {
            this.header.put(cell.getStringCellValue(), cell);
        }
        this.row = row;
    }

    @Override
    public String getDataType(String value) {
        Cell cell = null;
        if (this.header != null && this.header.get(value) != null) {
            int index = this.header.get(value).getColumnIndex();
            cell = this.row.getCell(index);
        }
        return ExcelRecord.getIRI(cell);
    }

    @Override
    public List<Object> get(String value) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            Object obj;
            int index = this.header.get(value).getColumnIndex();
            Cell cell = this.row.getCell(index);
            switch (cell.getCellType()) {
                case NUMERIC: {
                    double d = cell.getNumericCellValue();
                    if (d % 1.0 == 0.0) {
                        obj = (int)d;
                        break;
                    }
                    obj = d;
                    break;
                }
                case BOOLEAN: {
                    obj = cell.getBooleanCellValue();
                    break;
                }
                default: {
                    obj = cell.getStringCellValue();
                }
            }
            result.add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        return result;
    }

    public static String getIRI(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case NUMERIC: {
                return cell.getNumericCellValue() % 1.0 == 0.0 ? XSDDatatype.XSDinteger.getURI() : XSDDatatype.XSDdouble.getURI();
            }
            case BOOLEAN: {
                return XSDDatatype.XSDboolean.getURI();
            }
        }
        return XSDDatatype.XSDstring.getURI();
    }
}

