/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.rml.Utils;
import be.ugent.rml.access.Access;
import be.ugent.rml.records.CSVRecord;
import be.ugent.rml.records.Record;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.input.BOMInputStream;

class CSVW {
    private CSVParserBuilder csvParser = new CSVParserBuilder().withIgnoreLeadingWhiteSpace(true);
    private Charset csvCharset = StandardCharsets.UTF_8;
    private QuadStore rmlStore;
    private Term dialect;
    private Term logicalSource;
    private List<String> nulls;
    private boolean skipHeader = false;
    private String commentPrefix = "#";

    CSVW(QuadStore rmlStore, Term logicalSource) {
        this.rmlStore = rmlStore;
        this.logicalSource = logicalSource;
        this.nulls = new ArrayList<String>();
        this.setOptions();
    }

    List<Record> getRecords(Access access) throws IOException, CsvException, SQLException, ClassNotFoundException {
        int skipLines = this.skipHeader ? 1 : 0;
        try (BOMInputStream inputStream = new BOMInputStream(access.getInputStream());){
            List records = new CSVReaderBuilder((Reader)new InputStreamReader((InputStream)inputStream, this.csvCharset)).withCSVParser((ICSVParser)this.csvParser.build()).withSkipLines(skipLines).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build().readAll();
            records = records.stream().filter(row -> !row[0].startsWith(this.getCommentPrefix())).collect(Collectors.toList());
            String[] header = (String[])records.get(0);
            Stream<String[]> readRecords = records.subList(1, records.size()).stream().filter(r -> ((String[])r).length != 0 && (((String[])r).length != 1 || r[0] != null));
            if (this.getTrim()) {
                readRecords = readRecords.map(r -> (String[])Arrays.stream(r).map(String::trim).toArray(String[]::new));
            }
            List<Record> list = readRecords.map(record -> new CSVRecord(header, (String[])record, access.getDataTypes())).map(this::replaceNulls).collect(Collectors.toList());
            return list;
        }
    }

    private void setOptions() {
        List<Term> dialectTerms;
        List<Term> sources = Utils.getObjectsFromQuads(this.rmlStore.getQuads(this.logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#source"), null));
        Term source = sources.get(0);
        List<Term> nullTerms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(source, new NamedNode("http://www.w3.org/ns/csvw#null"), null));
        if (!nullTerms.isEmpty()) {
            this.nulls.addAll(nullTerms.stream().map(Term::getValue).collect(Collectors.toList()));
        }
        if (!(dialectTerms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(source, new NamedNode("http://www.w3.org/ns/csvw#dialect"), null))).isEmpty()) {
            this.dialect = dialectTerms.get(0);
            this.csvParser = this.csvParser.withSeparator(this.getDelimiter().charValue()).withEscapeChar(this.getEscapeCharacter().charValue()).withIgnoreLeadingWhiteSpace(this.getTrim()).withQuoteChar(this.getQuoteCharacter().charValue());
            this.skipHeader = this.getSkipHeaderRecord();
            this.commentPrefix = this.getCommentPrefix();
            String encoding = this.getValueFromTerm("encoding");
            if (encoding != null) {
                this.csvCharset = Charset.forName(encoding);
            }
        }
    }

    private String getValueFromTerm(String term) {
        List<Term> terms = Utils.getObjectsFromQuads(this.rmlStore.getQuads(this.dialect, new NamedNode("http://www.w3.org/ns/csvw#" + term), null));
        if (!terms.isEmpty()) {
            return terms.get(0).getValue();
        }
        return null;
    }

    private String getCommentPrefix() {
        String output = this.getValueFromTerm("commentPrefix");
        if (output == null) {
            return this.commentPrefix;
        }
        return output;
    }

    private boolean getSkipHeaderRecord() {
        String output = this.getValueFromTerm("header");
        if (output == null) {
            return this.skipHeader;
        }
        return output.equals("true");
    }

    private boolean getTrim() {
        String output = this.getValueFromTerm("trim");
        if (output == null) {
            return this.csvParser.isIgnoreLeadingWhiteSpace();
        }
        return output.equals("true");
    }

    private Character getDelimiter() {
        String output = this.getValueFromTerm("delimiter");
        if (output == null) {
            return Character.valueOf(this.csvParser.getSeparator());
        }
        return Character.valueOf(output.toCharArray()[0]);
    }

    private Character getEscapeCharacter() {
        String output = this.getValueFromTerm("doubleQuote");
        if (output == null) {
            return Character.valueOf(this.csvParser.getEscapeChar());
        }
        return Character.valueOf(output.equals("true") ? (char)'\\' : '\"');
    }

    private Character getQuoteCharacter() {
        String output = this.getValueFromTerm("quoteChar");
        if (output == null) {
            return Character.valueOf(this.csvParser.getQuoteChar());
        }
        return Character.valueOf(output.toCharArray()[0]);
    }

    public CSVRecord replaceNulls(CSVRecord record) {
        Map<String, String> data = record.getData();
        data.forEach((key, value) -> {
            if (this.nulls.contains(value)) {
                data.put((String)key, (String)null);
            }
        });
        return record;
    }
}

