/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.metadata;

import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.time.Instant;
import java.util.List;

public class DatasetLevelMetadataGenerator {
    public static void createMetadata(Term rdfDataset, Term rdfDatasetGeneration, Term rmlMapper, QuadStore result, List<Term> logicalSources, String startTimestamp, String stopTimestamp, String[] mappingFiles) {
        result.addQuad(rdfDataset, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/ns/prov#Entity"));
        result.addQuad(rdfDataset, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://rdfs.org/ns/void#Dataset"));
        result.addQuad(rdfDataset, new NamedNode("http://www.w3.org/ns/prov#generatedAtTime"), new Literal(Instant.now().toString(), new NamedNode("http://www.w3.org/2001/XMLSchema#dateTime")));
        result.addQuad(rdfDataset, new NamedNode("http://www.w3.org/ns/prov#wasGeneratedBy"), rdfDatasetGeneration);
        result.addQuad(rdfDataset, new NamedNode("http://www.w3.org/ns/prov#wasAssociatedWith"), rmlMapper);
        result.addQuad(rmlMapper, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/ns/prov#Agent"));
        result.addQuad(rmlMapper, new NamedNode("http://www.w3.org/ns/prov#type"), new NamedNode("http://www.w3.org/ns/prov#SoftwareAgent"));
        result.addQuad(rdfDatasetGeneration, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/ns/prov#Activity"));
        result.addQuad(rdfDatasetGeneration, new NamedNode("http://www.w3.org/ns/prov#generated"), rdfDataset);
        result.addQuad(rdfDatasetGeneration, new NamedNode("http://www.w3.org/ns/prov#startedAtTime"), new Literal(startTimestamp, new NamedNode("http://www.w3.org/2001/XMLSchema#dateTime")));
        result.addQuad(rdfDatasetGeneration, new NamedNode("http://www.w3.org/ns/prov#endedAtTime"), new Literal(stopTimestamp, new NamedNode("http://www.w3.org/2001/XMLSchema#dateTime")));
        for (String mappingFile : mappingFiles) {
            result.addQuad(rdfDatasetGeneration, new NamedNode("http://www.w3.org/ns/prov#used"), new NamedNode(String.format("file://%s", mappingFile)));
        }
        for (Term logicalSource : logicalSources) {
            result.addQuad(rdfDataset, new NamedNode("http://www.w3.org/ns/prov#wasDerivedFrom"), logicalSource);
            result.addQuad(rdfDatasetGeneration, new NamedNode("http://www.w3.org/ns/prov#used"), logicalSource);
        }
    }
}

