/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.conformer;

import be.ugent.rml.Utils;
import be.ugent.rml.conformer.R2RMLConverter;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MappingConformer {
    private QuadStore store;
    private List<Term> unconvertedTriplesMaps = new ArrayList<Term>();
    private Map<String, String> mappingOptions;

    public MappingConformer(QuadStore store) throws Exception {
        this(store, null);
    }

    public MappingConformer(QuadStore store, Map<String, String> mappingOptions) throws Exception {
        this.store = store;
        this.mappingOptions = mappingOptions;
    }

    public boolean conform() throws Exception {
        boolean conversionNeeded = this.detect();
        if (conversionNeeded) {
            this.convert();
        }
        return conversionNeeded;
    }

    private boolean detect() throws Exception {
        R2RMLConverter converter = new R2RMLConverter(this.store);
        List<Term> triplesMaps = Utils.getSubjectsFromQuads(this.store.getQuads(null, new NamedNode("http://www.w3.org/ns/r2rml#subjectMap"), null));
        List<Term> logicalSources = Utils.getSubjectsFromQuads(this.store.getQuads(null, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalSource"), null));
        List<Term> logicalTables = Utils.getSubjectsFromQuads(this.store.getQuads(null, new NamedNode("http://www.w3.org/ns/r2rml#logicalTable"), null));
        if ((triplesMaps = triplesMaps.stream().filter(term -> logicalSources.contains(term) || logicalTables.contains(term)).collect(Collectors.toList())).isEmpty()) {
            throw new Exception("Mapping requires at least one TriplesMap");
        }
        for (Term triplesMap : triplesMaps) {
            if (!converter.detect(triplesMap)) continue;
            this.unconvertedTriplesMaps.add(triplesMap);
        }
        return !this.unconvertedTriplesMaps.isEmpty();
    }

    private void convert() throws Exception {
        R2RMLConverter converter = new R2RMLConverter(this.store);
        for (Term unconvertedTriplesMap : this.unconvertedTriplesMaps) {
            converter.convert(unconvertedTriplesMap, this.mappingOptions);
        }
    }

    boolean differenceInConformer(QuadStore store) {
        return this.store.isSubset(store);
    }

    boolean differenceInGivenStore(QuadStore store) {
        return store.isSubset(this.store);
    }

    public QuadStore getStore() {
        return this.store;
    }
}

