/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml;

import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.rml.Mapping;
import be.ugent.rml.MappingInfo;
import be.ugent.rml.PredicateObjectGraphMapping;
import be.ugent.rml.RecordFunctionExecutorFactory;
import be.ugent.rml.StrictMode;
import be.ugent.rml.Utils;
import be.ugent.rml.extractor.ConstantExtractor;
import be.ugent.rml.extractor.HashExtractor;
import be.ugent.rml.extractor.ReferenceExtractor;
import be.ugent.rml.functions.DynamicMultipleRecordsFunctionExecutor;
import be.ugent.rml.functions.DynamicSingleRecordFunctionExecutor;
import be.ugent.rml.functions.MultipleRecordsFunctionExecutor;
import be.ugent.rml.functions.ParameterValueOriginPair;
import be.ugent.rml.functions.ParameterValuePair;
import be.ugent.rml.functions.SingleRecordFunctionExecutor;
import be.ugent.rml.functions.StaticMultipleRecordsFunctionExecutor;
import be.ugent.rml.functions.TermGeneratorOriginPair;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import be.ugent.rml.termgenerator.BlankNodeGenerator;
import be.ugent.rml.termgenerator.LiteralGenerator;
import be.ugent.rml.termgenerator.NamedNodeGenerator;
import be.ugent.rml.termgenerator.TermGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingFactory {
    private final Agent functionAgent;
    private MappingInfo subjectMappingInfo;
    private List<MappingInfo> graphMappingInfos;
    private Term triplesMap;
    private QuadStore store;
    private List<PredicateObjectGraphMapping> predicateObjectGraphMappings;
    private boolean ignoreDoubleQuotes;
    private final String baseIRI;
    private final StrictMode strictMode;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public MappingFactory(Agent functionAgent, String baseIRI, StrictMode strictMode) {
        this.functionAgent = functionAgent;
        this.baseIRI = baseIRI;
        this.strictMode = strictMode;
    }

    public Mapping createMapping(Term triplesMap, QuadStore store) throws Exception {
        this.triplesMap = triplesMap;
        this.store = store;
        this.subjectMappingInfo = null;
        this.predicateObjectGraphMappings = new ArrayList<PredicateObjectGraphMapping>();
        this.graphMappingInfos = null;
        this.ignoreDoubleQuotes = this.areDoubleQuotesIgnored(store, triplesMap);
        this.parseSubjectMap();
        this.parsePredicateObjectMaps();
        this.graphMappingInfos = this.parseGraphMapsAndShortcuts(this.subjectMappingInfo.getTerm());
        return new Mapping(this.subjectMappingInfo, this.predicateObjectGraphMappings, this.graphMappingInfos);
    }

    private void parseSubjectMap() throws Exception {
        if (this.subjectMappingInfo == null) {
            List<Term> subjectmaps = Utils.getObjectsFromQuads(this.store.getQuads(this.triplesMap, new NamedNode("http://www.w3.org/ns/r2rml#subjectMap"), null));
            if (!subjectmaps.isEmpty()) {
                TermGenerator generator;
                boolean isBlankNode;
                if (subjectmaps.size() > 1) {
                    throw new Exception(String.format("%s has %d Subject Maps. You can only have one.", this.triplesMap, subjectmaps.size()));
                }
                Term subjectmap = subjectmaps.get(0);
                List<Term> functionValues = Utils.getObjectsFromQuads(this.store.getQuads(subjectmap, new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue"), null));
                List<Term> termTypes = Utils.getObjectsFromQuads(this.store.getQuads(subjectmap, new NamedNode("http://www.w3.org/ns/r2rml#termType"), null));
                if (termTypes.contains(new NamedNode("http://www.w3.org/ns/r2rml#Literal"))) {
                    throw new Exception(this.triplesMap + " is a Literal Term Map. Accepted term types for Subject Maps are: IRI, Blank Node");
                }
                boolean bl = isBlankNode = !termTypes.isEmpty() && termTypes.get(0).equals(new NamedNode("http://www.w3.org/ns/r2rml#BlankNode"));
                if (functionValues.isEmpty()) {
                    SingleRecordFunctionExecutor executor;
                    generator = isBlankNode ? ((executor = RecordFunctionExecutorFactory.generate(this.store, subjectmap, true, this.ignoreDoubleQuotes)) != null ? new BlankNodeGenerator(executor) : new BlankNodeGenerator()) : new NamedNodeGenerator(RecordFunctionExecutorFactory.generate(this.store, subjectmap, true, this.ignoreDoubleQuotes), this.baseIRI, this.strictMode);
                } else {
                    SingleRecordFunctionExecutor functionExecutor = this.parseFunctionTermMap(functionValues.get(0));
                    generator = isBlankNode ? new BlankNodeGenerator(functionExecutor) : new NamedNodeGenerator(functionExecutor, this.baseIRI, this.strictMode);
                }
                List<Term> targets = Utils.getObjectsFromQuads(this.store.getQuads(subjectmap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalTarget"), null));
                this.subjectMappingInfo = new MappingInfo(subjectmap, generator, targets);
                List<Term> classes = Utils.getObjectsFromQuads(this.store.getQuads(subjectmap, new NamedNode("http://www.w3.org/ns/r2rml#class"), null));
                for (Term c : classes) {
                    NamedNodeGenerator predicateGenerator = new NamedNodeGenerator(new ConstantExtractor("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), this.baseIRI, this.strictMode);
                    NamedNodeGenerator objectGenerator = new NamedNodeGenerator(new ConstantExtractor(c.getValue()), this.baseIRI, this.strictMode);
                    this.predicateObjectGraphMappings.add(new PredicateObjectGraphMapping(new MappingInfo(subjectmap, predicateGenerator), new MappingInfo(subjectmap, objectGenerator), null, null));
                }
            } else {
                throw new Exception(this.triplesMap + " has no Subject Map. Each Triples Map should have exactly one Subject Map.");
            }
        }
    }

    private void parsePredicateObjectMaps() throws Exception {
        List<Term> predicateobjectmaps = Utils.getObjectsFromQuads(this.store.getQuads(this.triplesMap, new NamedNode("http://www.w3.org/ns/r2rml#predicateObjectMap"), null));
        for (Term pom : predicateobjectmaps) {
            List<MappingInfo> predicateMappingInfos = this.parsePredicateMapsAndShortcuts(pom);
            List<MappingInfo> graphMappingInfos = this.parseGraphMapsAndShortcuts(pom);
            this.parseObjectMapsAndShortcutsAndGeneratePOGGenerators(pom, predicateMappingInfos, graphMappingInfos);
        }
    }

    private void parseObjectMapsAndShortcutsAndGeneratePOGGenerators(Term termMap, List<MappingInfo> predicateMappingInfos, List<MappingInfo> graphMappingInfos) throws IOException {
        this.parseObjectMapsAndShortcutsWithCallback(termMap, (oMappingInfo, childOrParent) -> {
            MappingInfo lMappingInfo = this.parseLanguageMappingInfo(oMappingInfo.getTerm());
            predicateMappingInfos.forEach(pMappingInfo -> {
                if (graphMappingInfos.isEmpty()) {
                    this.predicateObjectGraphMappings.add(new PredicateObjectGraphMapping((MappingInfo)pMappingInfo, (MappingInfo)oMappingInfo, null, lMappingInfo));
                } else {
                    graphMappingInfos.forEach(gMappingInfo -> this.predicateObjectGraphMappings.add(new PredicateObjectGraphMapping((MappingInfo)pMappingInfo, (MappingInfo)oMappingInfo, (MappingInfo)gMappingInfo, lMappingInfo)));
                }
            });
        }, (parentTriplesMap, joinConditionFunctionExecutors) -> predicateMappingInfos.forEach(pMappingInfo -> {
            List<PredicateObjectGraphMapping> pos = this.getPredicateObjectGraphMappingFromMultipleGraphMappingInfos((MappingInfo)pMappingInfo, null, graphMappingInfos);
            pos.forEach(pogMappingInfo -> {
                pogMappingInfo.setParentTriplesMap((Term)parentTriplesMap);
                joinConditionFunctionExecutors.forEach(jcfe -> pogMappingInfo.addJoinCondition((MultipleRecordsFunctionExecutor)jcfe));
                this.predicateObjectGraphMappings.add((PredicateObjectGraphMapping)pogMappingInfo);
            });
        }));
    }

    private void parseObjectMapsAndShortcutsWithCallback(Term termMap, BiConsumer<MappingInfo, String> objectMapCallback, BiConsumer<Term, List<MultipleRecordsFunctionExecutor>> refObjectMapCallback) throws IOException {
        List<Term> objectmaps = Utils.getObjectsFromQuads(this.store.getQuads(termMap, new NamedNode("http://www.w3.org/ns/r2rml#objectMap"), null));
        for (Term objectmap : objectmaps) {
            this.parseObjectMapWithCallback(objectmap, objectMapCallback, refObjectMapCallback);
        }
        List<Term> objectsConstants = Utils.getObjectsFromQuads(this.store.getQuads(termMap, new NamedNode("http://www.w3.org/ns/r2rml#object"), null));
        for (Term o : objectsConstants) {
            ConstantExtractor fn = new ConstantExtractor(o.getValue());
            TermGenerator gen = o instanceof Literal ? new LiteralGenerator(fn) : new NamedNodeGenerator(fn, this.baseIRI, this.strictMode);
            objectMapCallback.accept(new MappingInfo(termMap, gen), "child");
        }
    }

    private void parseObjectMapWithCallback(Term objectmap, BiConsumer<MappingInfo, String> objectMapCallback, BiConsumer<Term, List<MultipleRecordsFunctionExecutor>> refObjectMapCallback) throws IOException {
        List<Term> functionValues = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue"), null));
        Term termType = this.getTermType(objectmap, true);
        List<Term> datatypes = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://www.w3.org/ns/r2rml#datatype"), null));
        List<Term> parentTriplesMaps = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://www.w3.org/ns/r2rml#parentTriplesMap"), null));
        List<Term> parentTermMaps = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://semweb.mmlab.be/ns/rml#parentTermMap"), null));
        List<SingleRecordFunctionExecutor> languages = this.getLanguageExecutorsForObjectMap(objectmap);
        if (functionValues.isEmpty()) {
            boolean encodeIRI = termType != null && termType.getValue().equals("http://www.w3.org/ns/r2rml#IRI");
            SingleRecordFunctionExecutor executor = RecordFunctionExecutorFactory.generate(this.store, objectmap, encodeIRI, this.ignoreDoubleQuotes);
            if (parentTriplesMaps.isEmpty() && parentTermMaps.isEmpty()) {
                TermGenerator oGen = termType.equals(new NamedNode("http://www.w3.org/ns/r2rml#Literal")) ? (!datatypes.isEmpty() ? new LiteralGenerator(executor, datatypes.get(0)) : (!languages.isEmpty() ? new LiteralGenerator(executor, languages.get(0)) : new LiteralGenerator(executor))) : (termType.equals(new NamedNode("http://www.w3.org/ns/r2rml#IRI")) ? new NamedNodeGenerator(executor, this.baseIRI, this.strictMode) : (executor == null ? new BlankNodeGenerator() : new BlankNodeGenerator(executor)));
                Object languageMapInfo = null;
                List<Term> languageMaps = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://semweb.mmlab.be/ns/rml#languageMap"), null));
                List<Term> oTargets = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalTarget"), null));
                objectMapCallback.accept(new MappingInfo(objectmap, oGen, oTargets), "child");
            } else if (!parentTriplesMaps.isEmpty()) {
                if (parentTriplesMaps.size() > 1) {
                    this.logger.warn("{} has {} Parent Triples Maps. You can only have one. A random one is taken.", (Object)this.triplesMap, (Object)parentTriplesMaps.size());
                }
                Term parentTriplesMap = parentTriplesMaps.get(0);
                List<Term> rrJoinConditions = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://www.w3.org/ns/r2rml#joinCondition"), null));
                List<Term> rmljoinConditions = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://semweb.mmlab.be/ns/rml#joinCondition"), null));
                ArrayList<MultipleRecordsFunctionExecutor> joinConditionFunctionExecutors = new ArrayList<MultipleRecordsFunctionExecutor>();
                for (Term joinCondition : rrJoinConditions) {
                    List<String> parents = Utils.getLiteralObjectsFromQuads(this.store.getQuads(joinCondition, new NamedNode("http://www.w3.org/ns/r2rml#parent"), null));
                    List<String> childs = Utils.getLiteralObjectsFromQuads(this.store.getQuads(joinCondition, new NamedNode("http://www.w3.org/ns/r2rml#child"), null));
                    if (parents.isEmpty()) {
                        throw new Error("One of the join conditions of " + this.triplesMap + " is missing rr:parent.");
                    }
                    if (childs.isEmpty()) {
                        throw new Error("One of the join conditions of " + this.triplesMap + " is missing rr:child.");
                    }
                    HashMap<String, Object[]> parameters = new HashMap<String, Object[]>();
                    boolean ignoreDoubleQuotesInParent = this.areDoubleQuotesIgnored(this.store, parentTriplesMap);
                    ReferenceExtractor parent = new ReferenceExtractor(parents.get(0), ignoreDoubleQuotesInParent);
                    Object[] detailsParent = new Object[]{"parent", parent};
                    parameters.put("http://users.ugent.be/~bjdmeest/function/grel.ttl#valueParameter", detailsParent);
                    ReferenceExtractor child = new ReferenceExtractor(childs.get(0), this.ignoreDoubleQuotes);
                    Object[] detailsChild = new Object[]{"child", child};
                    parameters.put("http://users.ugent.be/~bjdmeest/function/grel.ttl#valueParameter2", detailsChild);
                    joinConditionFunctionExecutors.add(new StaticMultipleRecordsFunctionExecutor(parameters, this.functionAgent, "http://example.com/idlab/function/equal"));
                }
                for (Term joinCondition : rmljoinConditions) {
                    Term functionValue = Utils.getObjectsFromQuads(this.store.getQuads(joinCondition, new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue"), null)).get(0);
                    joinConditionFunctionExecutors.add(this.parseJoinConditionFunctionTermMap(functionValue));
                }
                List<Term> logicalSources = Utils.getObjectsFromQuads(this.store.getQuads(this.triplesMap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalSource"), null));
                Term logicalSource = null;
                if (!logicalSources.isEmpty()) {
                    logicalSource = logicalSources.get(0);
                }
                List<Term> parentLogicalSources = Utils.getObjectsFromQuads(this.store.getQuads(parentTriplesMap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalSource"), null));
                Term parentLogicalSource = null;
                if (!parentLogicalSources.isEmpty()) {
                    parentLogicalSource = parentLogicalSources.get(0);
                }
                if (logicalSource.equals(parentLogicalSource)) {
                    joinConditionFunctionExecutors.add(this.generateSameLogicalSourceJoinConditionFunctionTermMap());
                }
                if (refObjectMapCallback != null) {
                    refObjectMapCallback.accept(parentTriplesMap, joinConditionFunctionExecutors);
                }
            } else if (!parentTermMaps.isEmpty()) {
                this.parseObjectMapWithCallback(parentTermMaps.get(0), (objectGenerator, childOrParent) -> objectMapCallback.accept((MappingInfo)objectGenerator, "parent"), null);
            }
        } else {
            SingleRecordFunctionExecutor functionExecutor = this.parseFunctionTermMap(functionValues.get(0));
            TermGenerator gen = termType == null || termType.equals(new NamedNode("http://www.w3.org/ns/r2rml#Literal")) ? (!datatypes.isEmpty() ? new LiteralGenerator(functionExecutor, datatypes.get(0)) : (!languages.isEmpty() ? new LiteralGenerator(functionExecutor, languages.get(0)) : new LiteralGenerator(functionExecutor))) : new NamedNodeGenerator(functionExecutor, this.baseIRI, this.strictMode);
            List<Term> targets = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalTarget"), null));
            objectMapCallback.accept(new MappingInfo(objectmap, gen, targets), "child");
        }
    }

    private List<MappingInfo> parseGraphMapsAndShortcuts(Term termMap) throws Exception {
        ArrayList<MappingInfo> graphMappingInfos = new ArrayList<MappingInfo>();
        List<Term> graphMaps = Utils.getObjectsFromQuads(this.store.getQuads(termMap, new NamedNode("http://www.w3.org/ns/r2rml#graphMap"), null));
        for (Term graphMap : graphMaps) {
            TermGenerator generator;
            List<Term> functionValues = Utils.getObjectsFromQuads(this.store.getQuads(graphMap, new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue"), null));
            List<Term> termTypes = Utils.getObjectsFromQuads(this.store.getQuads(graphMap, new NamedNode("http://www.w3.org/ns/r2rml#termType"), null));
            Term termType = null;
            if (!termTypes.isEmpty() && (termType = termTypes.get(0)).equals(new NamedNode("http://www.w3.org/ns/r2rml#Literal"))) {
                throw new Exception("A Graph Map cannot generate literals.");
            }
            if (functionValues.isEmpty()) {
                SingleRecordFunctionExecutor executor = RecordFunctionExecutorFactory.generate(this.store, graphMap, true, this.ignoreDoubleQuotes);
                generator = termType == null || termType.equals(new NamedNode("http://www.w3.org/ns/r2rml#IRI")) ? new NamedNodeGenerator(executor, this.baseIRI, this.strictMode) : (executor == null ? new BlankNodeGenerator() : new BlankNodeGenerator(executor));
            } else {
                SingleRecordFunctionExecutor functionExecutor = this.parseFunctionTermMap(functionValues.get(0));
                generator = termType == null || termType.equals(new NamedNode("http://www.w3.org/ns/r2rml#IRI")) ? new NamedNodeGenerator(functionExecutor, this.baseIRI, this.strictMode) : new BlankNodeGenerator(functionExecutor);
            }
            List<Term> targets = Utils.getObjectsFromQuads(this.store.getQuads(graphMap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalTarget"), null));
            graphMappingInfos.add(new MappingInfo(termMap, generator, targets));
        }
        List<Term> graphShortcuts = Utils.getObjectsFromQuads(this.store.getQuads(termMap, new NamedNode("http://www.w3.org/ns/r2rml#graph"), null));
        for (Term graph : graphShortcuts) {
            String gStr = graph.getValue();
            graphMappingInfos.add(new MappingInfo(termMap, new NamedNodeGenerator(new ConstantExtractor(gStr), this.baseIRI, this.strictMode)));
        }
        return graphMappingInfos;
    }

    private List<MappingInfo> parsePredicateMapsAndShortcuts(Term termMap) throws IOException {
        ArrayList<MappingInfo> predicateMappingInfos = new ArrayList<MappingInfo>();
        List<Term> predicateMaps = Utils.getObjectsFromQuads(this.store.getQuads(termMap, new NamedNode("http://www.w3.org/ns/r2rml#predicateMap"), null));
        for (Term predicateMap : predicateMaps) {
            List<Term> functionValues = Utils.getObjectsFromQuads(this.store.getQuads(predicateMap, new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue"), null));
            List<Term> targets = Utils.getObjectsFromQuads(this.store.getQuads(predicateMap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalTarget"), null));
            if (functionValues.isEmpty()) {
                predicateMappingInfos.add(new MappingInfo(predicateMap, new NamedNodeGenerator(RecordFunctionExecutorFactory.generate(this.store, predicateMap, false, this.ignoreDoubleQuotes), this.baseIRI, this.strictMode), targets));
                continue;
            }
            SingleRecordFunctionExecutor functionExecutor = this.parseFunctionTermMap(functionValues.get(0));
            predicateMappingInfos.add(new MappingInfo(predicateMap, new NamedNodeGenerator(functionExecutor, this.baseIRI, this.strictMode), targets));
        }
        List<Term> predicateShortcuts = Utils.getObjectsFromQuads(this.store.getQuads(termMap, new NamedNode("http://www.w3.org/ns/r2rml#predicate"), null));
        for (Term predicate : predicateShortcuts) {
            String pStr = predicate.getValue();
            predicateMappingInfos.add(new MappingInfo(termMap, new NamedNodeGenerator(new ConstantExtractor(pStr), this.baseIRI, this.strictMode)));
        }
        return predicateMappingInfos;
    }

    private SingleRecordFunctionExecutor parseFunctionTermMap(Term functionValue) throws IOException {
        List<Term> functionPOMs = Utils.getObjectsFromQuads(this.store.getQuads(functionValue, new NamedNode("http://www.w3.org/ns/r2rml#predicateObjectMap"), null));
        ArrayList<ParameterValuePair> params = new ArrayList<ParameterValuePair>();
        for (Term pom : functionPOMs) {
            List<MappingInfo> pMappingInfos = this.parsePredicateMapsAndShortcuts(pom);
            List<MappingInfo> oMappingInfos = this.parseObjectMapsAndShortcuts(pom);
            ArrayList<TermGenerator> pGenerators = new ArrayList<TermGenerator>();
            pMappingInfos.forEach(mappingInfo -> pGenerators.add(mappingInfo.getTermGenerator()));
            ArrayList<TermGenerator> oGenerators = new ArrayList<TermGenerator>();
            oMappingInfos.forEach(mappingInfo -> oGenerators.add(mappingInfo.getTermGenerator()));
            params.add(new ParameterValuePair(pGenerators, oGenerators));
        }
        return new DynamicSingleRecordFunctionExecutor(params, this.functionAgent);
    }

    private MultipleRecordsFunctionExecutor parseJoinConditionFunctionTermMap(Term functionValue) throws IOException {
        List<Term> functionPOMs = Utils.getObjectsFromQuads(this.store.getQuads(functionValue, new NamedNode("http://www.w3.org/ns/r2rml#predicateObjectMap"), null));
        ArrayList<ParameterValueOriginPair> params = new ArrayList<ParameterValueOriginPair>();
        for (Term pom : functionPOMs) {
            List<MappingInfo> pMappingInfos = this.parsePredicateMapsAndShortcuts(pom);
            ArrayList<TermGenerator> pGenerators = new ArrayList<TermGenerator>();
            pMappingInfos.forEach(mappingInfo -> pGenerators.add(mappingInfo.getTermGenerator()));
            ArrayList<TermGeneratorOriginPair> objectGeneratorOriginPairs = new ArrayList<TermGeneratorOriginPair>();
            this.parseObjectMapsAndShortcutsWithCallback(pom, (oGen, childOrParent) -> objectGeneratorOriginPairs.add(new TermGeneratorOriginPair(oGen.getTermGenerator(), (String)childOrParent)), null);
            params.add(new ParameterValueOriginPair(pGenerators, objectGeneratorOriginPairs));
        }
        return new DynamicMultipleRecordsFunctionExecutor(params, this.functionAgent);
    }

    private MultipleRecordsFunctionExecutor generateSameLogicalSourceJoinConditionFunctionTermMap() throws IOException {
        HashMap<String, Object[]> parameters = new HashMap<String, Object[]>();
        HashExtractor parent = new HashExtractor();
        Object[] detailsParent = new Object[]{"parent", parent};
        parameters.put("http://users.ugent.be/~bjdmeest/function/grel.ttl#valueParameter", detailsParent);
        HashExtractor child = new HashExtractor();
        Object[] detailsChild = new Object[]{"child", child};
        parameters.put("http://users.ugent.be/~bjdmeest/function/grel.ttl#valueParameter2", detailsChild);
        return new StaticMultipleRecordsFunctionExecutor(parameters, this.functionAgent, "http://example.com/idlab/function/equal");
    }

    private List<MappingInfo> parseObjectMapsAndShortcuts(Term pom) throws IOException {
        ArrayList<MappingInfo> mappingInfos = new ArrayList<MappingInfo>();
        this.parseObjectMapsAndShortcutsWithCallback(pom, (mappingInfo, childOrParent) -> mappingInfos.add((MappingInfo)mappingInfo), (term, joinConditionFunctions) -> {});
        return mappingInfos;
    }

    private List<SingleRecordFunctionExecutor> getLanguageExecutorsForObjectMap(Term objectmap) throws IOException {
        ArrayList<SingleRecordFunctionExecutor> executors = new ArrayList<SingleRecordFunctionExecutor>();
        List<Term> languages = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://www.w3.org/ns/r2rml#language"), null));
        languages.stream().map(Term::getValue).forEach(language -> {
            if (!Utils.isValidrrLanguage(language)) {
                throw new RuntimeException(String.format("Language tag \"%s\" does not conform to BCP 47 standards", language));
            }
        });
        for (Term language2 : languages) {
            executors.add(new ConstantExtractor(language2.getValue()));
        }
        List<Term> languageMaps = Utils.getObjectsFromQuads(this.store.getQuads(objectmap, new NamedNode("http://semweb.mmlab.be/ns/rml#languageMap"), null));
        for (Term languageMap : languageMaps) {
            List<Term> functionValues = Utils.getObjectsFromQuads(this.store.getQuads(languageMap, new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue"), null));
            if (functionValues.isEmpty()) {
                executors.add(RecordFunctionExecutorFactory.generate(this.store, languageMap, false, this.ignoreDoubleQuotes));
                continue;
            }
            executors.add(this.parseFunctionTermMap(functionValues.get(0)));
        }
        return executors;
    }

    private MappingInfo parseLanguageMappingInfo(Term objectMap) {
        MappingInfo mappingInfo = null;
        if (objectMap == null) {
            return mappingInfo;
        }
        List<Term> languageMaps = Utils.getObjectsFromQuads(this.store.getQuads(objectMap, new NamedNode("http://semweb.mmlab.be/ns/rml#languageMap"), null));
        if (languageMaps.size() == 1) {
            Term l = languageMaps.get(0);
            List<Term> lTargets = Utils.getObjectsFromQuads(this.store.getQuads(l, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalTarget"), null));
            mappingInfo = new MappingInfo(l, lTargets);
        } else if (languageMaps.size() > 1) {
            this.logger.warn("Multiple language maps found, a random language map is used");
        }
        return mappingInfo;
    }

    private Term getTermType(Term map, boolean isObjectMap) {
        List<Term> termTypes = Utils.getObjectsFromQuads(this.store.getQuads(map, new NamedNode("http://www.w3.org/ns/r2rml#termType"), null));
        Term termType = null;
        if (!termTypes.isEmpty()) {
            termType = termTypes.get(0);
        } else {
            List<Term> constants = Utils.getObjectsFromQuads(this.store.getQuads(map, new NamedNode("http://www.w3.org/ns/r2rml#constant"), null));
            if (!constants.isEmpty()) {
                Term constant = constants.get(0);
                termType = constant instanceof Literal ? new NamedNode("http://www.w3.org/ns/r2rml#Literal") : (constant instanceof NamedNode ? new NamedNode("http://www.w3.org/ns/r2rml#IRI") : new NamedNode("http://www.w3.org/ns/r2rml#BlankNode"));
            } else if (isObjectMap) {
                boolean hasDatatype;
                boolean hasReference = !Utils.getObjectsFromQuads(this.store.getQuads(map, new NamedNode("http://semweb.mmlab.be/ns/rml#reference"), null)).isEmpty();
                boolean hasFunctionValues = !Utils.getObjectsFromQuads(this.store.getQuads(map, new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue"), null)).isEmpty();
                boolean hasLanguage = !Utils.getObjectsFromQuads(this.store.getQuads(map, new NamedNode("http://www.w3.org/ns/r2rml#language"), null)).isEmpty() || !Utils.getObjectsFromQuads(this.store.getQuads(map, new NamedNode("http://semweb.mmlab.be/ns/rml#languageMap"), null)).isEmpty();
                boolean bl = hasDatatype = !Utils.getObjectsFromQuads(this.store.getQuads(map, new NamedNode("http://www.w3.org/ns/r2rml#datatype"), null)).isEmpty();
                termType = hasReference || hasLanguage || hasDatatype || hasFunctionValues ? new NamedNode("http://www.w3.org/ns/r2rml#Literal") : new NamedNode("http://www.w3.org/ns/r2rml#IRI");
            } else {
                termType = new NamedNode("http://www.w3.org/ns/r2rml#IRI");
            }
        }
        return termType;
    }

    private List<PredicateObjectGraphMapping> getPredicateObjectGraphMappingFromMultipleGraphMappingInfos(MappingInfo pMappingInfo, MappingInfo oMappingInfo, List<MappingInfo> gMappingInfos) {
        ArrayList<PredicateObjectGraphMapping> list = new ArrayList<PredicateObjectGraphMapping>();
        MappingInfo lMappingInfo = null;
        if (oMappingInfo != null) {
            lMappingInfo = this.parseLanguageMappingInfo(oMappingInfo.getTerm());
        }
        for (MappingInfo gMappingInfo : gMappingInfos) {
            list.add(new PredicateObjectGraphMapping(pMappingInfo, oMappingInfo, gMappingInfo, lMappingInfo));
        }
        if (gMappingInfos.isEmpty()) {
            list.add(new PredicateObjectGraphMapping(pMappingInfo, oMappingInfo, null, lMappingInfo));
        }
        return list;
    }

    private boolean areDoubleQuotesIgnored(QuadStore store, Term triplesMap) {
        Term logicalSource;
        List<Term> sources;
        List<Term> logicalSources = Utils.getObjectsFromQuads(store.getQuads(triplesMap, new NamedNode("http://semweb.mmlab.be/ns/rml#logicalSource"), null));
        if (!logicalSources.isEmpty() && !(sources = Utils.getObjectsFromQuads(store.getQuads(logicalSource = logicalSources.get(0), new NamedNode("http://semweb.mmlab.be/ns/rml#source"), null))).isEmpty()) {
            Term source = sources.get(0);
            if (!(sources.get(0) instanceof Literal)) {
                List<Term> sourceType = Utils.getObjectsFromQuads(store.getQuads(source, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null));
                return sourceType.get(0).getValue().equals("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#Database");
            }
        }
        return false;
    }
}

