/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning.internal;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification;
import aws.smithy.kotlin.runtime.auth.awssigning.internal.AwsChunkedUtilKt;
import aws.smithy.kotlin.runtime.http.Headers;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0007\u001a\u0014\u0010\u0012\u001a\u00020\u0010*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0003\u001a\u00020\u0004*\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0003\u0010\b\"\u001e\u0010\t\u001a\u00020\u0004*\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"AWS_CHUNKED_THRESHOLD", "", "CHUNK_SIZE_BYTES", "isEligibleForAwsChunkedStreaming", "", "Laws/smithy/kotlin/runtime/http/HttpBody;", "isEligibleForAwsChunkedStreaming$annotations", "(Laws/smithy/kotlin/runtime/http/HttpBody;)V", "(Laws/smithy/kotlin/runtime/http/HttpBody;)Z", "useAwsChunkedEncoding", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "getUseAwsChunkedEncoding$annotations", "(Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;)V", "getUseAwsChunkedEncoding", "(Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;)Z", "setAwsChunkedHeaders", "", "Laws/smithy/kotlin/runtime/http/request/HttpRequestBuilder;", "writeTrailerSignature", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "signature", "", "writeTrailers", "trailers", "Laws/smithy/kotlin/runtime/http/Headers;", "aws-signing-common"})
@SourceDebugExtension(value={"SMAP\nAwsChunkedUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsChunkedUtil.kt\naws/smithy/kotlin/runtime/auth/awssigning/internal/AwsChunkedUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1045#2:86\n1855#2,2:87\n*S KotlinDebug\n*F\n+ 1 AwsChunkedUtil.kt\naws/smithy/kotlin/runtime/auth/awssigning/internal/AwsChunkedUtilKt\n*L\n31#1:86\n32#1:87,2\n*E\n"})
public final class AwsChunkedUtilKt {
    public static final int CHUNK_SIZE_BYTES = 65536;
    public static final int AWS_CHUNKED_THRESHOLD = 0x100000;

    public static final void writeTrailers(@NotNull SdkBuffer $this$writeTrailers, @NotNull Headers trailers) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTrailers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)trailers, (String)"trailers");
        Iterable $this$sortedBy$iv = trailers.entries();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry = (Map.Entry)a;
                boolean bl = false;
                String string = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                entry = (Map.Entry)b;
                Comparable comparable = (Comparable)((Object)string);
                bl = false;
                String string2 = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailers), (String)((String)entry.getKey()), (int)0, (int)0, (int)6, null);
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailers), (String)":", (int)0, (int)0, (int)6, null);
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailers), (String)CollectionsKt.joinToString$default((Iterable)((Iterable)entry.getValue()), (CharSequence)",", null, null, (int)0, null, (Function1)writeTrailers.2.1.INSTANCE, (int)30, null), (int)0, (int)0, (int)6, null);
            SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailers), (String)"\r\n", (int)0, (int)0, (int)6, null);
        }
    }

    public static final void writeTrailerSignature(@NotNull SdkBuffer $this$writeTrailerSignature, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTrailerSignature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$writeTrailerSignature), (String)("x-amz-trailer-signature:" + signature + "\r\n"), (int)0, (int)0, (int)6, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEligibleForAwsChunkedStreaming(@NotNull HttpBody $this$isEligibleForAwsChunkedStreaming) {
        Intrinsics.checkNotNullParameter((Object)$this$isEligibleForAwsChunkedStreaming, (String)"<this>");
        if (!($this$isEligibleForAwsChunkedStreaming instanceof HttpBody.SourceContent)) {
            if (!($this$isEligibleForAwsChunkedStreaming instanceof HttpBody.ChannelContent)) return false;
        }
        if ($this$isEligibleForAwsChunkedStreaming.getContentLength() == null) return false;
        if ($this$isEligibleForAwsChunkedStreaming.isOneShot()) return true;
        Long l = $this$isEligibleForAwsChunkedStreaming.getContentLength();
        Intrinsics.checkNotNull((Object)l);
        if (l <= 0x100000L) return false;
        return true;
    }

    @InternalApi
    public static /* synthetic */ void isEligibleForAwsChunkedStreaming$annotations(HttpBody httpBody) {
    }

    public static final boolean getUseAwsChunkedEncoding(@NotNull AwsSigningConfig $this$useAwsChunkedEncoding) {
        Intrinsics.checkNotNullParameter((Object)$this$useAwsChunkedEncoding, (String)"<this>");
        HashSpecification hashSpecification = $this$useAwsChunkedEncoding.getHashSpecification();
        return (hashSpecification instanceof HashSpecification.StreamingAws4HmacSha256Payload ? true : hashSpecification instanceof HashSpecification.StreamingAws4HmacSha256PayloadWithTrailers) ? true : hashSpecification instanceof HashSpecification.StreamingUnsignedPayloadWithTrailers;
    }

    @InternalApi
    public static /* synthetic */ void getUseAwsChunkedEncoding$annotations(AwsSigningConfig awsSigningConfig) {
    }

    @InternalApi
    public static final void setAwsChunkedHeaders(@NotNull HttpRequestBuilder $this$setAwsChunkedHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$setAwsChunkedHeaders, (String)"<this>");
        $this$setAwsChunkedHeaders.getHeaders().append("Content-Encoding", (Object)"aws-chunked");
        $this$setAwsChunkedHeaders.getHeaders().set("Transfer-Encoding", (Object)"chunked");
        HeadersBuilder headersBuilder = $this$setAwsChunkedHeaders.getHeaders();
        Long l = $this$setAwsChunkedHeaders.getBody().getContentLength();
        Intrinsics.checkNotNull((Object)l);
        headersBuilder.set("X-Amz-Decoded-Content-Length", (Object)String.valueOf(l));
    }
}

