/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.http.interceptors.businessmetrics;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials;
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsKt;
import aws.smithy.kotlin.runtime.businessmetrics.BusinessMetric;
import aws.smithy.kotlin.runtime.businessmetrics.BusinessMetricsUtilsKt;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.collections.AttributesKt;
import aws.smithy.kotlin.runtime.collections.MutableAttributes;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u001a\u001a\u0010\n\u001a\u00020\b*\u00020\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0007\u00a8\u0006\f"}, d2={"formatMetrics", "", "metrics", "", "Laws/smithy/kotlin/runtime/businessmetrics/BusinessMetric;", "logger", "Laws/smithy/kotlin/runtime/telemetry/logging/Logger;", "withBusinessMetric", "Laws/smithy/kotlin/runtime/auth/awscredentials/Credentials;", "metric", "withBusinessMetrics", "", "aws-http"})
@SourceDebugExtension(value={"SMAP\nAwsBusinessMetricsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsBusinessMetricsUtils.kt\naws/sdk/kotlin/runtime/http/interceptors/businessmetrics/AwsBusinessMetricsUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n774#2:116\n865#2,2:117\n1869#2,2:126\n1802#3,6:119\n1#4:125\n*S KotlinDebug\n*F\n+ 1 AwsBusinessMetricsUtils.kt\naws/sdk/kotlin/runtime/http/interceptors/businessmetrics/AwsBusinessMetricsUtilsKt\n*L\n18#1:116\n18#1:117,2\n110#1:126,2\n37#1:119,6\n*E\n"})
public final class AwsBusinessMetricsUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String formatMetrics(@NotNull Set<BusinessMetric> metrics, @NotNull Logger logger) {
        Integer lastCommaIndex;
        int n;
        byte[] metricsByteArray;
        String metricsString;
        block8: {
            void $this$indexOfLast$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Iterable $this$filter$iv = metrics;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                BusinessMetric it = (BusinessMetric)element$iv$iv;
                boolean bl2 = false;
                if (it.getIdentifier().length() > 2) {
                    Logger.warn$default((Logger)logger, null, () -> AwsBusinessMetricsUtilsKt.formatMetrics$lambda$1$lambda$0(it), (int)1, null);
                    bl = false;
                } else {
                    bl = true;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allowedMetrics = (List)destination$iv$iv;
            if (allowedMetrics.isEmpty()) {
                return "";
            }
            metricsString = CollectionsKt.joinToString$default((Iterable)allowedMetrics, (CharSequence)",", (CharSequence)"m/", null, (int)0, null, AwsBusinessMetricsUtilsKt::formatMetrics$lambda$2, (int)28, null);
            metricsByteArray = StringsKt.encodeToByteArray((String)metricsString);
            if (metricsByteArray.length <= 1024) {
                return metricsString;
            }
            destination$iv$iv = ArraysKt.sliceArray((byte[])metricsByteArray, (IntRange)RangesKt.until((int)0, (int)1024));
            boolean $i$f$indexOfLast = false;
            int n2 = ((void)$this$indexOfLast$iv).length + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    void it = $this$indexOfLast$iv[index$iv];
                    boolean bl = false;
                    if (!(it == 44)) continue;
                    n = index$iv;
                    break block8;
                } while (0 <= n2);
            }
            n = -1;
        }
        Integer n3 = n;
        int it = ((Number)n3).intValue();
        boolean bl = false;
        Integer n4 = lastCommaIndex = it != -1 ? n3 : null;
        if (lastCommaIndex != null) {
            it = ((Number)lastCommaIndex).intValue();
            boolean bl3 = false;
            return StringsKt.decodeToString((byte[])metricsByteArray, (int)0, (int)lastCommaIndex, (boolean)true);
        }
        throw new IllegalStateException("Business metrics are incorrectly formatted: " + metricsString);
    }

    @InternalApi
    @NotNull
    public static final Credentials withBusinessMetric(@NotNull Credentials $this$withBusinessMetric, @NotNull BusinessMetric metric) {
        Credentials credentials;
        Intrinsics.checkNotNullParameter((Object)$this$withBusinessMetric, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Attributes credentialsAttributes = $this$withBusinessMetric.getAttributes();
        if (credentialsAttributes instanceof MutableAttributes) {
            BusinessMetricsUtilsKt.emitBusinessMetric((MutableAttributes)((MutableAttributes)credentialsAttributes), (BusinessMetric)metric);
            credentials = $this$withBusinessMetric;
        } else {
            MutableAttributes newCredentialsAttributes = AttributesKt.toMutableAttributes((Attributes)credentialsAttributes);
            BusinessMetricsUtilsKt.emitBusinessMetric((MutableAttributes)newCredentialsAttributes, (BusinessMetric)metric);
            credentials = CredentialsKt.copy$default((Credentials)$this$withBusinessMetric, null, null, null, null, null, (Attributes)((Attributes)newCredentialsAttributes), (int)31, null);
        }
        return credentials;
    }

    @InternalApi
    @NotNull
    public static final Credentials withBusinessMetrics(@NotNull Credentials $this$withBusinessMetrics, @NotNull Set<? extends BusinessMetric> metrics) {
        Intrinsics.checkNotNullParameter((Object)$this$withBusinessMetrics, (String)"<this>");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        Credentials credentials = null;
        credentials = $this$withBusinessMetrics;
        Iterable $this$forEach$iv = metrics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BusinessMetric metric = (BusinessMetric)element$iv;
            boolean bl = false;
            credentials = AwsBusinessMetricsUtilsKt.withBusinessMetric($this$withBusinessMetrics, metric);
        }
        return credentials;
    }

    private static final String formatMetrics$lambda$1$lambda$0(BusinessMetric $it) {
        return "Business metric '" + $it.getIdentifier() + "' will be skipped due to length being > 2. This is likely a bug. Please raise an issue at https://github.com/awslabs/aws-sdk-kotlin/issues/new/choose";
    }

    private static final CharSequence formatMetrics$lambda$2(BusinessMetric it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIdentifier();
    }
}

