/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.component.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.DefaultComponentSelector;

public final class DefaultComponentSelectorTestCase
extends TestCase {
    private DefaultComponentSelector m_componentSelector;
    protected boolean m_exceptionThrown;

    public DefaultComponentSelectorTestCase() {
        this("DefaultComponentSelector Test Case");
    }

    public DefaultComponentSelectorTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.m_componentSelector = new DefaultComponentSelector();
        this.m_exceptionThrown = false;
    }

    protected void tearDown() throws Exception {
        this.m_componentSelector = null;
    }

    public void testlookup() throws Exception {
        Hint hintA = new Hint("a");
        Hint hintB = new Hint("b");
        this.m_componentSelector.put(hintA, new FeatureComponent(hintA));
        this.m_componentSelector.put(hintB, new FeatureComponent(hintB));
        FeatureComponent fComponent = (FeatureComponent)this.m_componentSelector.select(hintA);
        Assert.assertEquals((Object)hintA, (Object)fComponent.getFeature());
        FeatureComponent o = null;
        try {
            o = (FeatureComponent)this.m_componentSelector.select(new Hint("no component"));
        }
        catch (ComponentException ce) {
            this.m_exceptionThrown = true;
        }
        if (o == null) {
            Assert.assertTrue((String)"ComponentException was not thrown when component was not found by lookup.", (boolean)this.m_exceptionThrown);
        } else {
            Assert.assertTrue((String)"component was found by lookup ,when there was no component.", (boolean)false);
        }
    }

    public void testhasComponent() throws Exception {
        Hint hintA = new Hint("a");
        Hint hintB = new Hint("b");
        this.m_componentSelector.put(hintA, new FeatureComponent(hintA));
        Assert.assertTrue((boolean)this.m_componentSelector.hasComponent(hintA));
        Assert.assertTrue((!this.m_componentSelector.hasComponent(hintB) ? 1 : 0) != 0);
    }

    public void testmakeReadOnly() throws Exception {
        Hint hintA = new Hint("a");
        Hint hintB = new Hint("b");
        this.m_componentSelector.put(hintA, new FeatureComponent(hintA));
        FeatureComponent fComponent = (FeatureComponent)this.m_componentSelector.select(hintA);
        Assert.assertEquals((Object)hintA, (Object)fComponent.getFeature());
        this.m_componentSelector.makeReadOnly();
        try {
            this.m_componentSelector.put(hintB, new FeatureComponent(hintB));
        }
        catch (IllegalStateException se) {
            this.m_exceptionThrown = true;
        }
        Assert.assertTrue((String)"IllegalStateException was not thrown in  put after makeReadOnly.", (boolean)this.m_exceptionThrown);
    }

    class Hint {
        String m_name;

        public Hint(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }
    }

    class FeatureComponent
    implements Component {
        Object m_feature;

        public FeatureComponent(Object feature) {
            this.m_feature = feature;
        }

        public Object getFeature() {
            return this.m_feature;
        }
    }
}

