/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.groovy;

import au.com.dius.pact.consumer.groovy.DateMatcher;
import au.com.dius.pact.consumer.groovy.EachLikeMatcher;
import au.com.dius.pact.consumer.groovy.InvalidMatcherException;
import au.com.dius.pact.consumer.groovy.MaxLikeMatcher;
import au.com.dius.pact.consumer.groovy.MinLikeMatcher;
import au.com.dius.pact.consumer.groovy.RegexpMatcher;
import au.com.dius.pact.consumer.groovy.TimeMatcher;
import au.com.dius.pact.consumer.groovy.TimestampMatcher;
import au.com.dius.pact.consumer.groovy.TypeMatcher;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;

public class Matchers
implements GroovyObject {
    private static final String HEXADECIMAL = "[0-9a-fA-F]+";
    private static final String IP_ADDRESS = "(\\d{1,3}\\.)+\\d{1,3}";
    private static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    private static final int TEN = 10;
    public static final String TYPE = "type";
    private static final /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public Matchers() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Object regexp(Pattern re, String value) {
        return IndyInterface.bootstrap("invoke", "regexp", 0, Matchers.class, IndyInterface.bootstrap("invoke", "toString", 0, re), value);
    }

    public static Object regexp(String regexp, String value) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, value, regexp)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value, regexp}, new String[]{"Example \"", "\" does not match regular expression \"", "\""})));
        }
        return IndyInterface.bootstrap("init", "<init>", 0, RegexpMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{regexp, value})}));
    }

    public static Object hexValue(String value) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, value, HEXADECIMAL)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value}, new String[]{"Example \"", "\" is not a hexadecimal value"})));
        }
        String string = value;
        return IndyInterface.bootstrap("init", "<init>", 0, RegexpMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{HEXADECIMAL, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : IndyInterface.bootstrap("invoke", "random", 0, RandomStringUtils.class, TEN, "0123456789abcdef")})}));
    }

    public static Object identifier(Object value) {
        Object object = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{TYPE, IndyInterface.bootstrap("cast", "()", 0, object) != false ? object : (Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "randomNumeric", 0, RandomStringUtils.class, TEN), Long.class))})}));
    }

    public static Object ipAddress(String value) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, value, IP_ADDRESS)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value}, new String[]{"Example \"", "\" is not an ip adress"})));
        }
        String string = value;
        return IndyInterface.bootstrap("init", "<init>", 0, RegexpMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{IP_ADDRESS, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : "127.0.0.1"})}));
    }

    public static Object numeric(Number value) {
        Number number = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{"number", IndyInterface.bootstrap("cast", "()", 0, number) != false ? (Number)number : (Number)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "randomNumeric", 0, RandomStringUtils.class, TEN), Long.class)))})}));
    }

    @Deprecated
    public static Object real(Number value) {
        Number number = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{"real", IndyInterface.bootstrap("cast", "()", 0, number) != false ? number : IndyInterface.bootstrap("invoke", "div", 0, (BigDecimal)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "randomNumeric", 0, RandomStringUtils.class, TEN), BigDecimal.class)), $const$0)})}));
    }

    public static Object decimal(Number value) {
        Number number = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{"decimal", IndyInterface.bootstrap("cast", "()", 0, number) != false ? number : IndyInterface.bootstrap("invoke", "div", 0, (BigDecimal)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "randomNumeric", 0, RandomStringUtils.class, TEN), BigDecimal.class)), $const$0)})}));
    }

    public static Object integer(Long value) {
        Long l = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{"integer", IndyInterface.bootstrap("cast", "()", 0, l) != false ? l : (Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "randomNumeric", 0, RandomStringUtils.class, TEN), Long.class))})}));
    }

    public static Object timestamp(String pattern, Object value) {
        IndyInterface.bootstrap("invoke", "validateTimeValue", 0, Matchers.class, value, pattern);
        return IndyInterface.bootstrap("init", "<init>", 0, TimestampMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", value, "pattern", pattern}));
    }

    private static Object validateTimeValue(String value, String pattern) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && DefaultTypeTransformation.booleanUnbox((Object)pattern)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "parseDateStrictly", 0, DateUtils.class, value, pattern);
            try {
                return callSite;
            }
            catch (ParseException e) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value, pattern}, new String[]{"Example \"", "\" does not match pattern \"", "\""})));
            }
        }
        return null;
    }

    public static Object time(String pattern, Object value) {
        IndyInterface.bootstrap("invoke", "validateTimeValue", 0, Matchers.class, value, pattern);
        return IndyInterface.bootstrap("init", "<init>", 0, TimeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", value, "pattern", pattern}));
    }

    public static Object date(String pattern, Object value) {
        IndyInterface.bootstrap("invoke", "validateTimeValue", 0, Matchers.class, value, pattern);
        return IndyInterface.bootstrap("init", "<init>", 0, DateMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", value, "pattern", pattern}));
    }

    @Deprecated
    public static Object guid(String value) {
        return IndyInterface.bootstrap("invoke", "uuid", 0, Matchers.class, value);
    }

    public static Object uuid(String value) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, value, UUID_REGEX)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidMatcherException.class, new GStringImpl(new Object[]{value}, new String[]{"Example \"", "\" is not a UUID"})));
        }
        String string = value;
        return IndyInterface.bootstrap("init", "<init>", 0, RegexpMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{UUID_REGEX, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class))})}));
    }

    public static Object string(String value) {
        String string = value;
        return IndyInterface.bootstrap("init", "<init>", 0, TypeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{TYPE, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : IndyInterface.bootstrap("invoke", "randomAlphanumeric", 0, RandomStringUtils.class, TEN)})}));
    }

    public static Object maxLike(Integer max, Integer numberExamples, Closure closure) {
        return IndyInterface.bootstrap("init", "<init>", 0, MaxLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{max, closure}), "numberExamples", numberExamples}));
    }

    public static Object minLike(Integer min, Integer numberExamples, Closure closure) {
        return IndyInterface.bootstrap("init", "<init>", 0, MinLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{min, closure}), "numberExamples", numberExamples}));
    }

    public static Object eachLike(Integer numberExamples, Closure closure) {
        return IndyInterface.bootstrap("init", "<init>", 0, EachLikeMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"values", ScriptBytecodeAdapter.createList((Object[])new Object[]{null, closure}), "numberExamples", numberExamples}));
    }

    public static Object regexp(Pattern re) {
        return Matchers.regexp(re, null);
    }

    public static Object regexp(String regexp) {
        return Matchers.regexp(regexp, null);
    }

    public static Object hexValue() {
        return Matchers.hexValue(null);
    }

    public static Object identifier() {
        return Matchers.identifier(null);
    }

    public static Object ipAddress() {
        return Matchers.ipAddress(null);
    }

    public static Object numeric() {
        return Matchers.numeric(null);
    }

    @Deprecated
    public static Object real() {
        return Matchers.real(null);
    }

    public static Object decimal() {
        return Matchers.decimal(null);
    }

    public static Object integer() {
        return Matchers.integer(null);
    }

    public static Object timestamp(String pattern) {
        return Matchers.timestamp(pattern, null);
    }

    public static Object timestamp() {
        return Matchers.timestamp(null, null);
    }

    public static Object time(String pattern) {
        return Matchers.time(pattern, null);
    }

    public static Object time() {
        return Matchers.time(null, null);
    }

    public static Object date(String pattern) {
        return Matchers.date(pattern, null);
    }

    public static Object date() {
        return Matchers.date(null, null);
    }

    @Deprecated
    public static Object guid() {
        return Matchers.guid(null);
    }

    public static Object uuid() {
        return Matchers.uuid(null);
    }

    public static Object string() {
        return Matchers.string(null);
    }

    public static Object maxLike(Integer max, Closure closure) {
        return Matchers.maxLike(max, 1, closure);
    }

    public static Object minLike(Integer min, Closure closure) {
        return Matchers.minLike(min, 1, closure);
    }

    public static Object eachLike(Closure closure) {
        return Matchers.eachLike(1, closure);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Matchers.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        $const$0 = bigDecimal = new BigDecimal("100.0");
    }

    static {
        Matchers.__$swapInit();
    }

    public static final String getHEXADECIMAL() {
        return HEXADECIMAL;
    }

    public static final String getIP_ADDRESS() {
        return IP_ADDRESS;
    }

    public static final String getUUID_REGEX() {
        return UUID_REGEX;
    }
}

