/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.algos.gam.GamUtilsISplines;
import java.io.Serializable;

public class NBSplinesTypeI
implements Serializable {
    public final int _order;
    public double[][] _nodeCoeffs;
    private double[] _coeffLeft;
    private double[] _coeffRight;
    double[] _knots;
    public double _commonConst;
    private NBSplinesTypeI _left;
    private NBSplinesTypeI _right;
    public final int _totBasisFuncs;
    public final int _nKnots;

    public NBSplinesTypeI(double[] knots, int order, int basisIndex, int numKnotInt) {
        this._order = order;
        this._knots = GamUtilsISplines.extractKnots(basisIndex, order, knots);
        this._nodeCoeffs = new double[numKnotInt][];
        this.setConstNChildCoeffs(knots, basisIndex);
        this._left = null;
        this._right = null;
        this._nKnots = knots.length;
        this._totBasisFuncs = this._order + this._nKnots - 2;
    }

    protected static MSplineBasis[] genBasisFunctions(int totBasisFuncs, int order, double[] knots) {
        MSplineBasis[] basisFuncs = new MSplineBasis[totBasisFuncs];
        for (int index = 0; index < totBasisFuncs; ++index) {
            basisFuncs[index] = NBSplinesTypeI.formOneBasisFunc(index, order, knots);
        }
        return basisFuncs;
    }

    private static MSplineBasis formOneBasisFunc(int basisIndex, int order, double[] knots) {
        if (order == 1) {
            return new MSplineBasis(basisIndex, order, knots);
        }
        MSplineBasis oneBasis = new MSplineBasis(basisIndex, order, knots);
        oneBasis._first = NBSplinesTypeI.formOneBasisFunc(basisIndex, order - 1, knots);
        oneBasis._second = NBSplinesTypeI.formOneBasisFunc(basisIndex + 1, order - 1, knots);
        return oneBasis;
    }

    public void setConstNChildCoeffs(double[] knots, int basisIndex) {
        if (this._order <= 1) {
            double[] dArray;
            this._commonConst = 0.0;
            double temp = this._knots[1] - this._knots[0];
            if (temp == 0.0) {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = 0.0;
            } else {
                double[] dArray3 = new double[1];
                dArray = dArray3;
                dArray3[0] = 1.0 / temp;
            }
            this._coeffLeft = dArray;
            this._coeffRight = new double[]{0.0};
        } else {
            double temp = knots[basisIndex] - knots[basisIndex + this._order];
            this._commonConst = temp == 0.0 ? 0.0 : (double)this._order / (temp * (double)(this._order - 1));
            this._coeffLeft = new double[]{-knots[basisIndex], 1.0};
            this._coeffRight = new double[]{knots[this._order + basisIndex], -1.0};
        }
    }

    public static void extractNBSplineCoeffs(NBSplinesTypeI root, int order, double[] coeffParent, double constParent, int basisIndex) {
        if (order == 1) {
            double temp = root._knots[1] - root._knots[0];
            if (temp != 0.0) {
                root._nodeCoeffs[basisIndex] = GamUtilsISplines.polynomialProduct(new double[]{constParent / temp}, coeffParent);
            }
        } else {
            NBSplinesTypeI.extractNBSplineCoeffs(root._left, order - 1, root._coeffLeft, root._commonConst, basisIndex);
            NBSplinesTypeI.extractNBSplineCoeffs(root._right, order - 1, root._coeffRight, root._commonConst, basisIndex + 1);
            GamUtilsISplines.sumCoeffs(root._left._nodeCoeffs, root._right._nodeCoeffs, root._nodeCoeffs);
            GamUtilsISplines.combineParentCoef(coeffParent, constParent, root._nodeCoeffs);
        }
    }

    public static double[][] extractCoeffs(NBSplinesTypeI root, int basisIndex, double parentConst) {
        if (root._order == 1) {
            double temp = root._knots[1] - root._knots[0];
            if (temp != 0.0) {
                double temp2 = parentConst / temp;
                root._nodeCoeffs[basisIndex] = new double[]{temp2};
            }
            return root._nodeCoeffs;
        }
        NBSplinesTypeI.extractNBSplineCoeffs(root, root._order, new double[]{1.0}, parentConst, basisIndex);
        return root._nodeCoeffs;
    }

    public static NBSplinesTypeI formBasisDeriv(double[] knots, int order, int basisIndex, int numKnotInt) {
        if (order == 1) {
            return new NBSplinesTypeI(knots, order, basisIndex, numKnotInt);
        }
        NBSplinesTypeI nbsplines = new NBSplinesTypeI(knots, order, basisIndex, numKnotInt);
        nbsplines._left = NBSplinesTypeI.formBasisDeriv(nbsplines._knots, order - 1, 0, numKnotInt);
        nbsplines._right = NBSplinesTypeI.formBasisDeriv(nbsplines._knots, order - 1, 1, numKnotInt);
        return nbsplines;
    }

    public static class MSplineBasis
    implements Serializable {
        double[] _knots;
        private double[] _numerator;
        private double[] _oneOverDenominator;
        private MSplineBasis _first = null;
        private MSplineBasis _second = null;
        private double _constant;

        public MSplineBasis(int index, int order, double[] knots) {
            this._knots = GamUtilsISplines.extractKnots(index, order, knots);
            this._constant = order > 1 ? (double)order / ((double)order - 1.0) : 1.0;
            this._numerator = GamUtilsISplines.formNumerator(order, this._knots);
            this._oneOverDenominator = GamUtilsISplines.formDenominatorMSpline(order, this._knots);
        }

        public static double evaluate(double value, MSplineBasis root) {
            if (value < root._knots[0] || value >= root._knots[root._knots.length - 1]) {
                return 0.0;
            }
            if (root._first != null) {
                return root._constant * ((value - root._numerator[0]) * root._oneOverDenominator[0] * MSplineBasis.evaluate(value, root._first) + (root._numerator[1] - value) * root._oneOverDenominator[1] * MSplineBasis.evaluate(value, root._second));
            }
            double temp = root._knots[1] - root._knots[0];
            if (temp != 0.0) {
                return 1.0 / temp;
            }
            return 0.0;
        }
    }
}

