/*
 * Decompiled with CFR 0.152.
 */
package water.genmodel;

import java.lang.reflect.Constructor;

public abstract class AbstractBuildVersion {
    private static final String UNKNOWN_VERSION_MARKER = "(unknown)";
    public static final AbstractBuildVersion UNKNOWN_VERSION = new AbstractBuildVersion(){

        @Override
        public String projectVersion() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String lastCommitHash() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String describe() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String compiledOn() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String compiledBy() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String branchName() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }
    };

    public abstract String branchName();

    public abstract String lastCommitHash();

    public abstract String describe();

    public abstract String projectVersion();

    public abstract String compiledOn();

    public abstract String compiledBy();

    public String toString() {
        return "H2O-GENMODEL v" + this.projectVersion() + " (" + this.branchName() + " - " + this.lastCommitHash() + ")";
    }

    public String buildNumber() {
        String pv = this.projectVersion();
        if (pv.equals(UNKNOWN_VERSION_MARKER)) {
            return UNKNOWN_VERSION_MARKER;
        }
        String[] split_pv = pv.split("\\.");
        String bn = split_pv[split_pv.length - 1];
        return bn;
    }

    private String getValue(String name) {
        switch (name) {
            case "projectVersion": {
                return this.projectVersion();
            }
            case "lastCommitHash": {
                return this.lastCommitHash();
            }
            case "describe": {
                return this.describe();
            }
            case "compiledOn": {
                return this.compiledOn();
            }
            case "compiledBy": {
                return this.compiledBy();
            }
            case "branchName": {
                return this.branchName();
            }
        }
        return null;
    }

    public static AbstractBuildVersion getBuildVersion() {
        AbstractBuildVersion abv = UNKNOWN_VERSION;
        try {
            Class<?> klass = Class.forName("water.genmodel.BuildVersion");
            Constructor<?> constructor = klass.getConstructor(new Class[0]);
            abv = (AbstractBuildVersion)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return abv;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"projectVersion"};
        }
        AbstractBuildVersion buildVersion = AbstractBuildVersion.getBuildVersion();
        System.out.print(buildVersion.getValue(args[0]));
        for (int i = 1; i < args.length; ++i) {
            System.out.print(' ');
            System.out.print(buildVersion.getValue(args[i]));
        }
        System.out.println();
    }
}

