/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class OneHotEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap;

    OneHotEncoder(String columnName, int targetIndex, String[] domainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        this.domainMap = new HashMap<String, Integer>(domainValues.length);
        for (int j = 0; j < domainValues.length; ++j) {
            this.domainMap.put(domainValues[j], j);
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer levelIndex = this.domainMap.get(levelName);
        if (levelIndex == null) {
            return false;
        }
        this.makeHot(levelIndex, rawData);
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        this.makeHot(this.domainMap.size(), rawData);
    }

    private void makeHot(int index, double[] rawData) {
        for (int i = 0; i < this.domainMap.size() + 1; ++i) {
            rawData[this.targetIndex + i] = index == i ? 1.0 : 0.0;
        }
    }

    public String toString() {
        return "OneHotEncoder{columnName='" + this.columnName + '\'' + ", targetIndex=" + this.targetIndex + ", domainMap=" + this.domainMap + '}';
    }
}

