/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.tools.PrintMojo;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SharedTreeSubgraph {
    public final int subgraphNumber;
    public final String name;
    public SharedTreeNode rootNode;
    public int fontSize = 14;
    public boolean setDecimalPlaces = false;
    public int nPlaces = -1;
    public ArrayList<SharedTreeNode> nodesArray;

    SharedTreeSubgraph(int sn, String n) {
        this.subgraphNumber = sn;
        this.name = n;
        this.nodesArray = new ArrayList();
    }

    public SharedTreeNode makeRootNode() {
        assert (this.nodesArray.size() == 0);
        SharedTreeNode n = new SharedTreeNode(0, null, this.subgraphNumber, 0);
        n.setInclusiveNa(true);
        this.nodesArray.add(n);
        this.rootNode = n;
        return n;
    }

    public void setDecimalPlace(int nplaces) {
        this.setDecimalPlaces = true;
        this.nPlaces = nplaces;
    }

    public void setFontSize(int fontsize) {
        this.fontSize = fontsize;
    }

    public SharedTreeNode makeLeftChildNode(SharedTreeNode parent) {
        SharedTreeNode child = new SharedTreeNode(this.nodesArray.size(), parent, this.subgraphNumber, parent.getDepth() + 1);
        this.nodesArray.add(child);
        this.makeLeftEdge(parent, child);
        return child;
    }

    public SharedTreeNode makeRightChildNode(SharedTreeNode parent) {
        SharedTreeNode child = new SharedTreeNode(this.nodesArray.size(), parent, this.subgraphNumber, parent.getDepth() + 1);
        this.nodesArray.add(child);
        this.makeRightEdge(parent, child);
        return child;
    }

    private void makeLeftEdge(SharedTreeNode parent, SharedTreeNode child) {
        parent.setLeftChild(child);
    }

    private void makeRightEdge(SharedTreeNode parent, SharedTreeNode child) {
        parent.setRightChild(child);
    }

    public SharedTreeNode walkNodes(String path) {
        SharedTreeNode n = this.rootNode;
        block4: for (int i = 0; i < path.length(); ++i) {
            if (n == null) {
                return null;
            }
            switch (path.charAt(i)) {
                case 'L': {
                    n = n.getLeftChild();
                    continue block4;
                }
                case 'R': {
                    n = n.getRightChild();
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Invalid path specification '" + path + "'. Paths must only be made of 'L' and 'R' characters.");
                }
            }
        }
        return n;
    }

    public float scoreTree(double[] data) {
        SharedTreeNode n = this.rootNode;
        while (!n.isLeaf()) {
            int id = n.next(data);
            n = this.nodesArray.get(id);
        }
        return n.getPredValue();
    }

    void print() {
        System.out.println("");
        System.out.println("    ----- " + this.name + " -----");
        System.out.println("    Nodes");
        for (SharedTreeNode n : this.nodesArray) {
            n.print();
        }
        System.out.println("");
        System.out.println("    Edges");
        this.rootNode.printEdges();
    }

    void printDot(PrintStream os, int maxLevelsToPrintPerEdge, boolean detail, String optionalTitle, PrintMojo.PrintTreeOptions treeOptions) {
        os.println("");
        os.println("subgraph cluster_" + this.subgraphNumber + " {");
        os.println("/* Nodes */");
        int maxLevel = -1;
        for (SharedTreeNode n : this.nodesArray) {
            if (n.getDepth() <= maxLevel) continue;
            maxLevel = n.getDepth();
        }
        for (int level = 0; level <= maxLevel; ++level) {
            os.println("");
            os.println("/* Level " + level + " */");
            os.println("{");
            this.rootNode.printDotNodesAtLevel(os, level, detail, treeOptions);
            os.println("}");
        }
        os.println("");
        os.println("/* Edges */");
        for (SharedTreeNode n : this.nodesArray) {
            n.printDotEdges(os, maxLevelsToPrintPerEdge, this.rootNode.getWeight(), detail, treeOptions);
        }
        os.println("");
        os.println("fontsize=40");
        String title = SharedTreeNode.escapeQuotes(optionalTitle != null ? optionalTitle : this.name);
        os.println("label=\"" + title + "\"");
        os.println("}");
    }

    public void printDot(PrintStream os, int maxLevelsToPrintPerEdge, boolean detail, String optionalTitle, PrintMojo.PrintTreeOptions treeOptions, boolean isDirected) {
        os.println("");
        os.println((isDirected ? "digraph " : "subgraph cluster_") + this.subgraphNumber + " {");
        os.println("/* Nodes */");
        int maxLevel = -1;
        for (SharedTreeNode n : this.nodesArray) {
            if (n.getDepth() <= maxLevel) continue;
            maxLevel = n.getDepth();
        }
        for (int level = 0; level <= maxLevel; ++level) {
            os.println("");
            os.println("/* Level " + level + " */");
            os.println("{");
            this.rootNode.printDotNodesAtLevel(os, level, detail, treeOptions);
            os.println("}");
        }
        os.println("");
        os.println("/* Edges */");
        for (SharedTreeNode n : this.nodesArray) {
            n.printDotEdges(os, maxLevelsToPrintPerEdge, this.rootNode.getWeight(), detail, treeOptions);
        }
        os.println("");
        os.println("fontsize=40");
        String title = SharedTreeNode.escapeQuotes(optionalTitle != null ? optionalTitle : this.name);
        os.println("label=\"" + title + "\"");
        os.println("}");
    }

    Map<String, Object> toJson() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("index", this.subgraphNumber);
        json.put("name", this.name);
        json.put("root", this.rootNode.toJson());
        return json;
    }

    public SharedTreeNode[] getNodes() {
        return this.nodesArray.toArray(new SharedTreeNode[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedTreeSubgraph that = (SharedTreeSubgraph)o;
        return this.subgraphNumber == that.subgraphNumber && Objects.equals(this.name, that.name) && Objects.equals(this.rootNode, that.rootNode) && Objects.equals(this.nodesArray, that.nodesArray);
    }

    public int hashCode() {
        return Objects.hash(this.subgraphNumber);
    }

    public String toString() {
        return "SharedTreeSubgraph{subgraphNumber=" + this.subgraphNumber + ", name='" + this.name + '\'' + '}';
    }
}

