/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.GenModel;
import hex.genmodel.easy.BinaryColumnMapper;
import hex.genmodel.easy.BinaryDomainMapConstructor;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EigenEncoderColumnMapper;
import hex.genmodel.easy.EigenEncoderDomainMapConstructor;
import hex.genmodel.easy.EnumEncoderColumnMapper;
import hex.genmodel.easy.EnumEncoderDomainMapConstructor;
import hex.genmodel.easy.EnumLimitedEncoderColumnMapper;
import hex.genmodel.easy.EnumLimitedEncoderDomainMapConstructor;
import hex.genmodel.easy.LabelEncoderDomainMapConstructor;
import hex.genmodel.easy.OneHotEncoderColumnMapper;
import hex.genmodel.easy.OneHotEncoderDomainMapConstructor;
import java.util.Map;

public enum CategoricalEncoding {
    AUTO(false){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m) {
            return new EnumEncoderColumnMapper(m).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m, Map<String, Integer> columnMapping) {
            return new EnumEncoderDomainMapConstructor(m, columnMapping).create();
        }
    }
    ,
    OneHotExplicit(false){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m) {
            return new OneHotEncoderColumnMapper(m).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m, Map<String, Integer> columnMapping) {
            return new OneHotEncoderDomainMapConstructor(m, columnMapping).create();
        }
    }
    ,
    Binary(false){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m) {
            return new BinaryColumnMapper(m).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m, Map<String, Integer> columnMapping) {
            return new BinaryDomainMapConstructor(m, columnMapping).create();
        }
    }
    ,
    EnumLimited(true){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m) {
            return new EnumLimitedEncoderColumnMapper(m).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m, Map<String, Integer> columnMapping) {
            return new EnumLimitedEncoderDomainMapConstructor(m, columnMapping).create();
        }
    }
    ,
    Eigen(true){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m) {
            return new EigenEncoderColumnMapper(m).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m, Map<String, Integer> columnMapping) {
            return new EigenEncoderDomainMapConstructor(m, columnMapping).create();
        }
    }
    ,
    LabelEncoder(false){

        @Override
        public Map<String, Integer> createColumnMapping(GenModel m) {
            return new EnumEncoderColumnMapper(m).create();
        }

        @Override
        public Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m, Map<String, Integer> columnMapping) {
            return new LabelEncoderDomainMapConstructor(m, columnMapping).create();
        }
    };

    private final boolean _parametrized;

    private CategoricalEncoding(boolean parametrized) {
        this._parametrized = parametrized;
    }

    public abstract Map<String, Integer> createColumnMapping(GenModel var1);

    public abstract Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel var1, Map<String, Integer> var2);

    public boolean isParametrized() {
        return this._parametrized;
    }
}

