/*
 * Decompiled with CFR 0.152.
 */
package water.util.fp;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import water.util.fp.Function;

public class FP {
    public static final Option<?> None = new Option<Object>(){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean nonEmpty() {
            return false;
        }

        @Override
        public <U> Option<U> flatMap(Function<Object, Option<U>> f) {
            return None;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }

        public String toString() {
            return "None";
        }

        public int hashCode() {
            return -1;
        }
    };

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static <T> Option<T> Some(T t) {
        return new Some<T>(t);
    }

    public static <T> Option<T> Option(T t) {
        return t == null ? None : new Some<T>(t);
    }

    public static <T> Option<T> flatten(Option<Option<T>> optOptT) {
        return optOptT.isEmpty() ? None : (Option)((Some)optOptT).get();
    }

    public static <T> Option<T> headOption(Iterator<T> it) {
        return FP.Option(it.hasNext() ? (T)it.next() : null);
    }

    public static <T> Option<T> headOption(Iterable<T> ts) {
        return FP.headOption(ts.iterator());
    }

    public static final class Some<T>
    implements Option<T> {
        private List<T> contents;

        public Some(T t) {
            this.contents = Collections.singletonList(t);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean nonEmpty() {
            return true;
        }

        @Override
        public <U> Option<U> flatMap(Function<T, Option<U>> f) {
            return f.apply(this.get());
        }

        @Override
        public Iterator<T> iterator() {
            return this.contents.iterator();
        }

        public T get() {
            return this.contents.get(0);
        }

        public String toString() {
            return "Some(" + this.get() + ")";
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Some && FP.equal(this.get(), ((Some)o).get());
        }

        public int hashCode() {
            return FP.hashCode(this.get());
        }
    }

    static interface Option<T>
    extends Iterable<T> {
        public boolean isEmpty();

        public boolean nonEmpty();

        public <U> Option<U> flatMap(Function<T, Option<U>> var1);
    }
}

