/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import water.AutoBuffer;
import water.Futures;
import water.H2O;
import water.MRTask;
import water.MemoryManager;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OIllegalValueException;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMapLong;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.IcedDouble;
import water.util.IcedHashMap;
import water.util.IcedInt;
import water.util.PrettyPrint;
import water.util.RandomUtils;

public class VecUtils {
    public static Vec toCategoricalVec(Vec src) {
        switch (src.get_type()) {
            case 4: {
                return src.makeCopy(src.domain());
            }
            case 0: 
            case 3: {
                return VecUtils.numericToCategorical(src);
            }
            case 2: {
                return VecUtils.stringToCategorical(src);
            }
            case 5: {
                throw new H2OIllegalArgumentException("Changing time/date columns to a categorical column has not been implemented yet.");
            }
            case 1: {
                throw new H2OIllegalArgumentException("Changing UUID columns to a categorical column has not been implemented yet.");
            }
        }
        throw new H2OIllegalArgumentException("Unrecognized column type " + src.get_type_str() + " given to toCategoricalVec()");
    }

    public static Vec stringToCategorical(Vec vec) {
        final String[] vecDomain = new CollectStringVecDomain().domain(vec);
        MRTask task = new MRTask(){
            private transient HashMap<String, Integer> lookupTable;

            @Override
            protected void setupLocal() {
                this.lookupTable = new HashMap(vecDomain.length);
                for (int i = 0; i < vecDomain.length; ++i) {
                    this.lookupTable.put(vecDomain[i], i);
                }
            }

            @Override
            public void map(Chunk c, NewChunk nc) {
                BufferedString bs = new BufferedString();
                for (int row = 0; row < c.len(); ++row) {
                    if (c.isNA(row)) {
                        nc.addNA();
                        continue;
                    }
                    c.atStr(bs, row);
                    String strRepresentation = bs.toString();
                    if (strRepresentation.contains("\ufffd")) {
                        nc.addNum(this.lookupTable.get(bs.toSanitizedString()).intValue(), 0);
                        continue;
                    }
                    nc.addNum(this.lookupTable.get(strRepresentation).intValue(), 0);
                }
            }
        };
        task.doAll(new byte[]{4}, vec);
        return task.outputFrame(null, null, new String[][]{vecDomain}).vec(0);
    }

    public static Vec numericToCategorical(Vec src) {
        if (src.isInt()) {
            long[] dom;
            int min = (int)src.min();
            int max = (int)src.max();
            long[] lArray = dom = min >= 0 && max < 0x7FFFFFFB ? ((CollectDomainFast)new CollectDomainFast(max).doAll(src)).domain() : ((CollectIntegerDomain)new CollectIntegerDomain().doAll(src)).domain();
            if (dom.length > 10000000) {
                throw new H2OIllegalArgumentException("Column domain is too large to be represented as an categorical: " + dom.length + " > " + 10000000);
            }
            return VecUtils.copyOver(src, (byte)4, dom);
        }
        if (src.isNumeric()) {
            final double[] dom = ((CollectDoubleDomain)new CollectDoubleDomain(null, 10000).doAll(src)).domain();
            String[] strDom = new String[dom.length];
            for (int i = 0; i < dom.length; ++i) {
                strDom[i] = String.valueOf(dom[i]);
            }
            Vec dst = src.makeZero(strDom);
            new MRTask(){

                @Override
                public void map(Chunk c0, Chunk c1) {
                    for (int r = 0; r < c0._len; ++r) {
                        double d = c0.atd(r);
                        if (Double.isNaN(d)) {
                            c1.setNA(r);
                            continue;
                        }
                        c1.set(r, Arrays.binarySearch(dom, d));
                    }
                }
            }.doAll(src, dst);
            assert (dst.min() == 0.0);
            assert (dst.max() == (double)(dom.length - 1));
            return dst;
        }
        throw new IllegalArgumentException("calling numericToCategorical conversion on a non numeric column");
    }

    public static Vec toNumericVec(Vec src) {
        switch (src.get_type()) {
            case 4: {
                return VecUtils.categoricalToInt(src);
            }
            case 2: {
                return VecUtils.stringToNumeric(src);
            }
            case 1: 
            case 3: 
            case 5: {
                return src.makeCopy(null, (byte)3);
            }
        }
        throw new H2OIllegalArgumentException("Unrecognized column type " + src.get_type_str() + " given to toNumericVec()");
    }

    public static Vec stringToNumeric(Vec src) {
        if (!src.isString()) {
            throw new H2OIllegalArgumentException("stringToNumeric conversion only works on string columns");
        }
        Vec res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk._len; ++i) {
                        newChk.addNA();
                    }
                } else {
                    BufferedString tmpStr = new BufferedString();
                    block6: for (int i = 0; i < chk._len; ++i) {
                        if (!chk.isNA(i)) {
                            tmpStr = chk.atStr(tmpStr, i);
                            switch (tmpStr.getNumericType()) {
                                case 0: {
                                    newChk.addNA();
                                    continue block6;
                                }
                                case 1: {
                                    newChk.addNum(Long.parseLong(tmpStr.toString()), 0);
                                    continue block6;
                                }
                                case 2: {
                                    newChk.addNum(Double.parseDouble(tmpStr.toString()));
                                    continue block6;
                                }
                                default: {
                                    throw new H2OIllegalValueException("Received unexpected type when parsing a string to a number.", this);
                                }
                            }
                        }
                        newChk.addNA();
                    }
                }
            }
        }.doAll((byte)3, src)).outputFrame().anyVec();
        assert (res != null);
        return res;
    }

    public static Vec categoricalToInt(final Vec src) {
        if (src.isInt() && (src.domain() == null || src.domain().length == 0)) {
            return VecUtils.copyOver(src, (byte)3, null);
        }
        if (!src.isCategorical()) {
            throw new IllegalArgumentException("categoricalToInt conversion only works on categorical columns.");
        }
        boolean useDomain = false;
        Vec newVec = VecUtils.copyOver(src, (byte)3, null);
        try {
            Integer.parseInt(src.domain()[0]);
            useDomain = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (useDomain) {
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        if (c.isNA(i)) continue;
                        c.set(i, Integer.parseInt(src.domain()[(int)c.at8(i)]));
                    }
                }
            }.doAll(newVec);
        }
        return newVec;
    }

    public static Vec toStringVec(Vec src) {
        switch (src.get_type()) {
            case 2: {
                return src.makeCopy();
            }
            case 4: {
                return VecUtils.categoricalToStringVec(src);
            }
            case 1: {
                return VecUtils.UUIDToStringVec(src);
            }
            case 0: 
            case 3: 
            case 5: {
                return VecUtils.numericToStringVec(src);
            }
        }
        throw new H2OIllegalArgumentException("Unrecognized column type " + src.get_type_str() + " given to toStringVec().");
    }

    public static Vec categoricalToStringVec(Vec src) {
        if (!src.isCategorical()) {
            throw new H2OIllegalValueException("Can not convert a non-categorical column using categoricalToStringVec().", src);
        }
        return ((Categorical2StrChkTask)new Categorical2StrChkTask(src.domain()).doAll((byte)2, src)).outputFrame().anyVec();
    }

    public static Vec numericToStringVec(Vec src) {
        if (src.isCategorical() || src.isUUID()) {
            throw new H2OIllegalValueException("Cannot convert a non-numeric column using numericToStringVec() ", src);
        }
        Vec res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk._len; ++i) {
                        newChk.addNA();
                    }
                } else {
                    for (int i = 0; i < chk._len; ++i) {
                        if (!chk.isNA(i)) {
                            newChk.addStr(PrettyPrint.number(chk, chk.atd(i), 4));
                            continue;
                        }
                        newChk.addNA();
                    }
                }
            }
        }.doAll((byte)2, src)).outputFrame().anyVec();
        assert (res != null);
        return res;
    }

    public static Vec UUIDToStringVec(Vec src) {
        if (!src.isUUID()) {
            throw new H2OIllegalArgumentException("UUIDToStringVec() conversion only works on UUID columns");
        }
        Vec res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk._len; ++i) {
                        newChk.addNA();
                    }
                } else {
                    for (int i = 0; i < chk._len; ++i) {
                        if (!chk.isNA(i)) {
                            newChk.addStr(PrettyPrint.UUID(chk.at16l(i), chk.at16h(i)));
                            continue;
                        }
                        newChk.addNA();
                    }
                }
            }
        }.doAll((byte)2, src)).outputFrame().anyVec();
        assert (res != null);
        return res;
    }

    public static Vec categoricalDomainsToNumeric(final Vec src) {
        if (!src.isCategorical()) {
            throw new H2OIllegalArgumentException("categoricalToNumeric() conversion only works on categorical columns");
        }
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c) {
                for (int i = 0; i < c._len; ++i) {
                    if (c.isNA(i)) continue;
                    c.set(i, Integer.parseInt(src.domain()[(int)c.at8(i)]));
                }
            }
        }.doAll((byte)3, src)).outputFrame().anyVec();
    }

    public static String[] collectDomainFast(Vec vec) throws IllegalArgumentException {
        if (!vec.isCategorical()) {
            throw new IllegalArgumentException("Unable to collect domain on a non-categorical vector.");
        }
        long[] newDomainIndices = ((CollectDomainFast)new CollectDomainFast((int)vec.max()).doAll(vec)).domain();
        String[] originalDomain = vec.domain();
        String[] newDomain = new String[newDomainIndices.length];
        for (int i = 0; i < newDomain.length; ++i) {
            newDomain[i] = originalDomain[(int)newDomainIndices[i]];
        }
        return newDomain;
    }

    public static void deleteVecs(Vec[] vs, int cnt) {
        Futures f = new Futures();
        for (int i = 0; i < cnt; ++i) {
            vs[cnt].remove(f);
        }
        f.blockForPending();
    }

    private static Vec copyOver(Vec src, byte type, long[] domain) {
        String[][] dom = new String[][]{domain == null ? null : ArrayUtils.toString(domain)};
        return ((CPTask)new CPTask(domain).doAll(type, src)).outputFrame(null, dom).anyVec();
    }

    public static int[] getLocalChunkIds(Vec v) {
        if (v._cids != null) {
            return v._cids;
        }
        int[] res = new int[Math.max(v.nChunks() / H2O.CLOUD.size(), 1)];
        int j = 0;
        for (int i = 0; i < v.nChunks(); ++i) {
            if (!v.isHomedLocally(i)) continue;
            if (res.length == j) {
                res = Arrays.copyOf(res, 2 * res.length);
            }
            res[j++] = i;
        }
        v._cids = j == res.length ? res : Arrays.copyOf(res, j);
        return v._cids;
    }

    public static Vec remapDomain(String[] newDomainValues, Vec originalVec) throws UnsupportedOperationException, IllegalArgumentException {
        Objects.requireNonNull(newDomainValues);
        if (originalVec.domain() == null) {
            throw new UnsupportedOperationException("Unable to remap domain values on a non-categorical vector.");
        }
        if (newDomainValues.length != originalVec.domain().length) {
            throw new IllegalArgumentException(String.format("For each of original domain levels, there must be a new mapping.There are %o domain levels, however %o mappings were supplied.", originalVec.domain().length, newDomainValues.length));
        }
        HashMap<String, HashSet<Integer>> map = new HashMap<String, HashSet<Integer>>();
        for (int i = 0; i < newDomainValues.length; ++i) {
            HashSet<Integer> indices = (HashSet<Integer>)map.get(newDomainValues[i]);
            if (indices == null) {
                indices = new HashSet<Integer>(1);
                indices.add(i);
                map.put(newDomainValues[i], indices);
                continue;
            }
            indices.add(i);
        }
        int[] indicesMap = MemoryManager.malloc4(originalVec.domain().length);
        String[] reducedDomain = new String[map.size()];
        int reducedDomainIdx = 0;
        for (String e : map.keySet()) {
            Set oldDomainIndices = (Set)map.get(e);
            reducedDomain[reducedDomainIdx] = e;
            Iterator iterator = oldDomainIndices.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                indicesMap[idx] = reducedDomainIdx;
            }
            ++reducedDomainIdx;
        }
        RemapDomainTask remapDomainTask = (RemapDomainTask)new RemapDomainTask(indicesMap).doAll(new byte[]{4}, originalVec);
        assert (remapDomainTask.outputFrame().numCols() == 1);
        Vec remappedVec = remapDomainTask.outputFrame().vec(0);
        remappedVec.setDomain(reducedDomain);
        return remappedVec;
    }

    public static Vec shuffleVec(Vec origVec, long seed) {
        Vec v = ((ShuffleVecTask)new ShuffleVecTask(origVec, seed).doAll(origVec.get_type(), origVec)).outputFrame().anyVec();
        if (origVec.isCategorical()) {
            v.setDomain(origVec.domain());
        }
        return v;
    }

    public static class ShuffleVecTask
    extends MRTask<ShuffleVecTask> {
        private final long _seed;
        private final Vec _vec;
        private transient int[] _localChunks;
        private transient int[] _permutatedChunks;

        public ShuffleVecTask(Vec vec, long seed) {
            this._seed = seed;
            this._vec = vec;
        }

        @Override
        protected void setupLocal() {
            this._localChunks = VecUtils.getLocalChunkIds(this._vec);
            this._permutatedChunks = (int[])this._localChunks.clone();
            this.permute(this._permutatedChunks, null);
        }

        private void permute(int[] arr, Random rng) {
            if (null == rng) {
                rng = RandomUtils.getRNG(this._seed);
            }
            for (int i = arr.length - 1; i > 0; --i) {
                int j = rng.nextInt(i + 1);
                int old = arr[i];
                arr[i] = arr[j];
                arr[j] = old;
            }
        }

        @Override
        public void map(Chunk _cs, NewChunk nc) {
            Random rng = RandomUtils.getRNG(this._seed + _cs.start());
            Chunk cs = this._vec.chunkForChunkIdx(this._permutatedChunks[Arrays.binarySearch(this._localChunks, _cs.cidx())]);
            int[] permutedRows = ArrayUtils.seq(0, cs._len);
            this.permute(permutedRows, rng);
            block8: for (int row : permutedRows) {
                if (cs.isNA(row)) {
                    nc.addNA();
                    continue;
                }
                switch (_cs.vec().get_type()) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        nc.addUUID(cs, row);
                        continue block8;
                    }
                    case 2: {
                        nc.addStr(cs, row);
                        continue block8;
                    }
                    case 3: {
                        nc.addNum(cs.atd(row));
                        continue block8;
                    }
                    case 4: {
                        nc.addCategorical((int)cs.at8(row));
                        continue block8;
                    }
                    case 5: {
                        nc.addNum(cs.at8(row), 0);
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported vector type: " + cs.vec().get_type());
                    }
                }
            }
        }
    }

    public static class DotProduct
    extends MRTask<DotProduct> {
        public double result;

        @Override
        public void map(Chunk[] bvs) {
            this.result = 0.0;
            int len = bvs[0]._len;
            for (int i = 0; i < len; ++i) {
                this.result += bvs[0].atd(i) * bvs[1].atd(i);
            }
        }

        @Override
        public void reduce(DotProduct mrt) {
            this.result += mrt.result;
        }
    }

    private static class RemapDomainTask
    extends MRTask<RemapDomainTask> {
        private final int[] _domainIndicesMap;

        public RemapDomainTask(int[] domainIndicesMap) {
            this._domainIndicesMap = domainIndicesMap;
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            for (int i = 0; i < c.len(); ++i) {
                nc.addCategorical(this._domainIndicesMap[(int)c.at8(i)]);
            }
        }
    }

    public static class ReorderTask
    extends MRTask<ReorderTask> {
        private int[] _map;

        public ReorderTask(int[] mapping) {
            this._map = mapping;
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            for (int i = 0; i < c._len; ++i) {
                if (c.isNA(i)) {
                    nc.addNA();
                    continue;
                }
                nc.addNum(this._map[(int)c.at8(i)], 0);
            }
        }
    }

    public static class MeanResponsePerLevelTask
    extends MRTask<MeanResponsePerLevelTask> {
        public double[] meanWeightedResponse;
        public double meanOverallWeightedResponse;
        private double[] wcounts;
        private int _len;

        public MeanResponsePerLevelTask(int len) {
            this._len = len;
        }

        @Override
        public void map(Chunk c, Chunk w, Chunk r) {
            this.wcounts = new double[this._len];
            this.meanWeightedResponse = new double[this._len];
            for (int i = 0; i < c._len; ++i) {
                double weight;
                if (c.isNA(i)) continue;
                int level = (int)c.at8(i);
                if (w.isNA(i) || (weight = w.atd(i)) == 0.0 || r.isNA(i)) continue;
                double response = r.atd(i);
                int n = level;
                this.wcounts[n] = this.wcounts[n] + weight;
                int n2 = level;
                this.meanWeightedResponse[n2] = this.meanWeightedResponse[n2] + weight * response;
            }
        }

        @Override
        public void reduce(MeanResponsePerLevelTask mrt) {
            ArrayUtils.add(this.wcounts, mrt.wcounts);
            ArrayUtils.add(this.meanWeightedResponse, mrt.meanWeightedResponse);
            mrt.wcounts = null;
            mrt.meanWeightedResponse = null;
        }

        @Override
        protected void postGlobal() {
            this.meanOverallWeightedResponse = 0.0;
            double sum = 0.0;
            for (int i = 0; i < this.meanWeightedResponse.length; ++i) {
                if (this.wcounts[i] == 0.0) continue;
                this.meanWeightedResponse[i] = this.meanWeightedResponse[i] / this.wcounts[i];
                this.meanOverallWeightedResponse += this.meanWeightedResponse[i];
                sum += this.wcounts[i];
            }
            this.meanOverallWeightedResponse /= sum;
        }
    }

    private static class CollectStringVecDomain
    extends MRTask<CollectStringVecDomain> {
        private IcedHashMap<String, IcedInt> _uniques = null;
        private final IcedInt _placeHolder = new IcedInt(1);

        private CollectStringVecDomain() {
        }

        @Override
        protected void setupLocal() {
            this._uniques = new IcedHashMap();
        }

        @Override
        public void map(Chunk c) {
            BufferedString bs = new BufferedString();
            for (int i = 0; i < c.len(); ++i) {
                if (c.isNA(i)) continue;
                c.atStr(bs, i);
                String strRepresentation = bs.toString();
                if (strRepresentation.contains("\ufffd")) {
                    this._uniques.put(bs.toSanitizedString(), this._placeHolder);
                    continue;
                }
                this._uniques.put(strRepresentation, this._placeHolder);
            }
        }

        @Override
        public void reduce(CollectStringVecDomain mrt) {
            if (this._uniques != mrt._uniques) {
                this._uniques.putAll(mrt._uniques);
            }
        }

        public String[] domain(Vec vec) {
            assert (vec.isString()) : "String vector expected. Unsupported vector type: " + vec.get_type_str();
            this.doAll(vec);
            return this.domain();
        }

        public String[] domain() {
            Object[] dom = this._uniques.keySet().toArray(new String[this._uniques.size()]);
            Arrays.sort(dom);
            return dom;
        }
    }

    private static class CPTask
    extends MRTask<CPTask> {
        private final long[] _domain;

        CPTask(long[] domain) {
            this._domain = domain;
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            for (int i = 0; i < c._len; ++i) {
                if (c.isNA(i)) {
                    nc.addNA();
                    continue;
                }
                if (this._domain == null) {
                    nc.addNum(c.at8(i));
                    continue;
                }
                long num = Arrays.binarySearch(this._domain, c.at8(i));
                if (num < 0L) {
                    throw new IllegalArgumentException("Could not find the categorical value!");
                }
                nc.addNum(num);
            }
        }
    }

    public static class CollectDomainFast
    extends MRTask<CollectDomainFast> {
        private final int _s;
        private boolean[] _u;
        private long[] _d;

        public CollectDomainFast(int s) {
            this._s = s;
        }

        @Override
        protected void setupLocal() {
            this._u = MemoryManager.mallocZ(this._s + 1);
        }

        @Override
        public void map(Chunk ys) {
            for (int row = 0; row < ys._len; ++row) {
                if (ys.isNA(row)) continue;
                this._u[(int)ys.at8((int)row)] = true;
            }
        }

        @Override
        public void reduce(CollectDomainFast mrt) {
            if (this._u != mrt._u) {
                ArrayUtils.or(this._u, mrt._u);
            }
        }

        @Override
        protected void postGlobal() {
            int c = 0;
            for (boolean b : this._u) {
                if (!b) continue;
                ++c;
            }
            this._d = MemoryManager.malloc8(c);
            int id = 0;
            for (int i = 0; i < this._u.length; ++i) {
                if (!this._u[i]) continue;
                this._d[id++] = i;
            }
            Arrays.sort(this._d);
        }

        public long[] domain() {
            return this._d;
        }
    }

    public static class DomainDedupe
    extends MRTask<DomainDedupe> {
        private final HashMap<Integer, Integer> _oldToNewDomainIndex;

        public DomainDedupe(HashMap<Integer, Integer> oldToNewDomainIndex) {
            this._oldToNewDomainIndex = oldToNewDomainIndex;
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            for (int row = 0; row < c._len; ++row) {
                if (!c.isNA(row)) {
                    int oldDomain = (int)c.at8(row);
                    nc.addNum(this._oldToNewDomainIndex.get(oldDomain).intValue());
                    continue;
                }
                nc.addNA();
            }
        }

        public static Vec domainDeduper(Vec vec, HashMap<String, ArrayList<Integer>> substringToOldDomainIndices) {
            HashMap<Integer, Integer> oldToNewDomainIndex = new HashMap<Integer, Integer>();
            int newDomainIndex = 0;
            TreeSet<String> alphabetizedSubstrings = new TreeSet<String>(substringToOldDomainIndices.keySet());
            for (String sub : alphabetizedSubstrings) {
                for (int oldDomainIndex : substringToOldDomainIndices.get(sub)) {
                    oldToNewDomainIndex.put(oldDomainIndex, newDomainIndex);
                }
                ++newDomainIndex;
            }
            DomainDedupe domainDedupe = new DomainDedupe(oldToNewDomainIndex);
            String[][] dom2D = new String[][]{(String[])Arrays.copyOf(alphabetizedSubstrings.toArray(), alphabetizedSubstrings.size(), String[].class)};
            return ((DomainDedupe)domainDedupe.doAll(new byte[]{4}, vec)).outputFrame(null, null, dom2D).anyVec();
        }
    }

    public static class CollectIntegerDomain
    extends MRTask<CollectIntegerDomain> {
        transient NonBlockingHashMapLong<String> _uniques;

        @Override
        protected void setupLocal() {
            this._uniques = new NonBlockingHashMapLong();
        }

        @Override
        public void map(Chunk ys) {
            for (int row = 0; row < ys._len; ++row) {
                if (ys.isNA(row)) continue;
                this._uniques.put(ys.at8(row), "");
            }
        }

        @Override
        public void reduce(CollectIntegerDomain mrt) {
            if (this._uniques != mrt._uniques) {
                this._uniques.putAll(mrt._uniques);
            }
        }

        public final AutoBuffer write_impl(AutoBuffer ab) {
            return ab.putA8(this._uniques == null ? null : this._uniques.keySetLong());
        }

        public final CollectIntegerDomain read_impl(AutoBuffer ab) {
            long[] ls = ab.getA8();
            assert (this._uniques == null || this._uniques.size() == 0);
            this._uniques = new NonBlockingHashMapLong();
            if (ls != null) {
                for (long l : ls) {
                    this._uniques.put(l, "");
                }
            }
            return this;
        }

        @Override
        public final void copyOver(CollectIntegerDomain that) {
            this._uniques = that._uniques;
        }

        public long[] domain() {
            long[] dom = this._uniques.keySetLong();
            Arrays.sort(dom);
            return dom;
        }
    }

    public static class CollectDoubleDomain
    extends MRTask<CollectDoubleDomain> {
        final double[] _sortedKnownDomain;
        private IcedHashMap<IcedDouble, IcedInt> _uniques;
        final int _maxDomain;
        final IcedInt _placeHolder = new IcedInt(1);

        public CollectDoubleDomain(double[] knownDomain, int maxDomainSize) {
            this._maxDomain = maxDomainSize;
            double[] dArray = this._sortedKnownDomain = knownDomain == null ? null : (double[])knownDomain.clone();
            if (this._sortedKnownDomain != null && !ArrayUtils.isSorted(knownDomain)) {
                Arrays.sort(this._sortedKnownDomain);
            }
        }

        @Override
        public void setupLocal() {
            this._uniques = new IcedHashMap();
        }

        public double[] domain() {
            double[] res = MemoryManager.malloc8d(this._uniques.size());
            int i = 0;
            for (IcedDouble v : this._uniques.keySet()) {
                res[i++] = v._val;
            }
            Arrays.sort(res);
            return res;
        }

        public String[] stringDomain(boolean integer) {
            double[] domain = this.domain();
            String[] stringDomain = new String[domain.length];
            for (int i = 0; i < domain.length; ++i) {
                stringDomain[i] = integer ? String.valueOf((int)domain[i]) : String.valueOf(domain[i]);
            }
            return stringDomain;
        }

        private IcedDouble addValue(IcedDouble val) {
            if (Double.isNaN(val._val)) {
                return val;
            }
            if (this._sortedKnownDomain != null && Arrays.binarySearch(this._sortedKnownDomain, val._val) >= 0) {
                return val;
            }
            if (!this._uniques.containsKey(val)) {
                this._uniques.put(val, this._placeHolder);
                val = new IcedDouble(0.0);
                if (this._uniques.size() > this._maxDomain) {
                    this.onMaxDomainExceeded(this._maxDomain, this._uniques.size());
                }
            }
            return val;
        }

        @Override
        public void map(Chunk ys) {
            IcedDouble val = new IcedDouble(0.0);
            int row = ys.nextNZ(-1);
            while (row < ys._len) {
                val = this.addValue(val.setVal(ys.atd(row)));
                row = ys.nextNZ(row);
            }
            if (ys.isSparseZero()) {
                this.addValue(val.setVal(0.0));
            }
        }

        @Override
        public void reduce(CollectDoubleDomain mrt) {
            if (this._uniques != mrt._uniques) {
                this._uniques.putAll(mrt._uniques);
            }
            if (this._uniques.size() > this._maxDomain) {
                this.onMaxDomainExceeded(this._maxDomain, this._uniques.size());
            }
        }

        protected void onMaxDomainExceeded(int maxDomainSize, int currentSize) {
            throw new RuntimeException("Too many unique values. Expected |uniques| < " + maxDomainSize + ", already got " + currentSize);
        }
    }

    private static class Categorical2StrChkTask
    extends MRTask<Categorical2StrChkTask> {
        final String[] _domain;

        Categorical2StrChkTask(String[] domain) {
            this._domain = domain;
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            for (int i = 0; i < c._len; ++i) {
                if (!c.isNA(i)) {
                    nc.addStr(this._domain == null ? "" + c.at8(i) : this._domain[(int)c.at8(i)]);
                    continue;
                }
                nc.addNA();
            }
        }
    }
}

