/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxProcFileReader {
    private String _systemData;
    private String _processData;
    private String _processStatus;
    private String _pid;
    private long _systemIdleTicks = -1L;
    private long _systemTotalTicks = -1L;
    private long _processTotalTicks = -1L;
    private long _processRss = -1L;
    private int _processCpusAllowed = -1;
    private int _processNumOpenFds = -1;
    private ArrayList<long[]> _cpuTicks = null;

    public boolean isWsl() {
        try {
            if (!new File("/proc/version").exists()) {
                return false;
            }
            String s = this.readFile(new File("/proc/version"));
            return s.contains("Microsoft");
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getSystemIdleTicks() {
        assert (this._systemIdleTicks > 0L);
        return this._systemIdleTicks;
    }

    public long getSystemTotalTicks() {
        assert (this._systemTotalTicks > 0L);
        return this._systemTotalTicks;
    }

    public long getProcessTotalTicks() {
        assert (this._processTotalTicks > 0L);
        return this._processTotalTicks;
    }

    public long[][] getCpuTicks() {
        assert (this._cpuTicks != null);
        return (long[][])this._cpuTicks.toArray((T[])new long[0][0]);
    }

    public long getProcessRss() {
        assert (this._processRss > 0L);
        return this._processRss;
    }

    private static boolean isOSNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        String osName = System.getProperty("os.name");
        return LinuxProcFileReader.isOSNameMatch(osName, osNamePrefix);
    }

    private static boolean IS_OS_LINUX() {
        return LinuxProcFileReader.getOSMatchesName("Linux") || LinuxProcFileReader.getOSMatchesName("LINUX");
    }

    public int getProcessCpusAllowed() {
        return this.getProcessCpusAllowed(LinuxProcFileReader.IS_OS_LINUX());
    }

    int getProcessCpusAllowed(boolean isLinux) {
        if (!isLinux) {
            return this.getProcessCpusAllowedFallback();
        }
        if (this._processCpusAllowed < 0) {
            return this.getProcessCpusAllowedFallback();
        }
        return this._processCpusAllowed;
    }

    int getProcessCpusAllowedFallback() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int getProcessNumOpenFds() {
        assert (this._processNumOpenFds > 0);
        return this._processNumOpenFds;
    }

    public String getProcessID() {
        return this._pid;
    }

    public void read() {
        String pid = "-1";
        try {
            this._pid = pid = LinuxProcFileReader.getProcessId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File f = new File("/proc/stat");
        if (!f.exists()) {
            return;
        }
        try {
            this.readSystemProcFile();
            this.readProcessProcFile(pid);
            this.readProcessNumOpenFds(pid);
            this.readProcessStatusFile(pid);
            this.parseSystemProcFile(this._systemData);
            this.parseProcessProcFile(this._processData);
            this.parseProcessStatusFile(this._processStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean valid() {
        return this._systemIdleTicks >= 0L && this._systemTotalTicks >= 0L && this._processTotalTicks >= 0L && this._processNumOpenFds >= 0;
    }

    public static int numSetBitsHex(String s) {
        int[] bits_set = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
        int nset = 0;
        for (int i = 0; i < s.length(); ++i) {
            Character ch = Character.valueOf(s.charAt(i));
            if (ch.charValue() == ',') continue;
            int x = Integer.parseInt(ch.toString(), 16);
            nset += bits_set[x];
        }
        return nset;
    }

    private static String getProcessId() throws Exception {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            throw new Exception("Can't get process Id");
        }
        return Long.toString(Long.parseLong(jvmName.substring(0, index)));
    }

    private String readFile(File f) throws Exception {
        int n;
        char[] buffer = new char[16384];
        FileReader fr = new FileReader(f);
        int bytesRead = 0;
        do {
            if ((n = fr.read(buffer, bytesRead, buffer.length - bytesRead)) < 0) {
                fr.close();
                return new String(buffer, 0, bytesRead);
            }
            if (n != 0) continue;
            fr.close();
            throw new Exception("LinuxProcFileReader readFile read 0 bytes");
        } while ((bytesRead += n) < buffer.length);
        fr.close();
        throw new Exception("LinuxProcFileReader readFile unexpected buffer full");
    }

    private void readSystemProcFile() {
        try {
            this._systemData = this.readFile(new File("/proc/stat"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void parseSystemProcFile(String s) {
        if (s == null) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(s));
            String line = reader.readLine();
            Pattern p = Pattern.compile("cpu\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*");
            Matcher m = p.matcher(line);
            boolean b = m.matches();
            if (!b) {
                return;
            }
            long systemUserTicks = Long.parseLong(m.group(1));
            long systemNiceTicks = Long.parseLong(m.group(2));
            long systemSystemTicks = Long.parseLong(m.group(3));
            this._systemIdleTicks = Long.parseLong(m.group(4));
            this._systemTotalTicks = systemUserTicks + systemNiceTicks + systemSystemTicks + this._systemIdleTicks;
            this._cpuTicks = new ArrayList();
            line = reader.readLine();
            while (line != null && (b = (m = (p = Pattern.compile("cpu(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*")).matcher(line)).matches())) {
                long cpuUserTicks = 0L;
                long cpuSystemTicks = 0L;
                long cpuOtherTicks = 0L;
                long cpuIdleTicks = 0L;
                cpuOtherTicks += Long.parseLong(m.group(3));
                cpuSystemTicks += Long.parseLong(m.group(4));
                cpuSystemTicks += Long.parseLong(m.group(7));
                long[] oneCpuTicks = new long[]{cpuUserTicks += Long.parseLong(m.group(2)), cpuSystemTicks += Long.parseLong(m.group(8)), cpuOtherTicks += Long.parseLong(m.group(6)), cpuIdleTicks += Long.parseLong(m.group(5))};
                this._cpuTicks.add(oneCpuTicks);
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessProcFile(String pid) {
        try {
            String s = "/proc/" + pid + "/stat";
            this._processData = this.readFile(new File(s));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void parseProcessProcFile(String s) {
        if (s == null) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(s));
            String line = reader.readLine();
            Pattern p = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+).*");
            Matcher m = p.matcher(line);
            boolean b = m.matches();
            if (!b) {
                return;
            }
            long processUserTicks = Long.parseLong(m.group(14));
            long processSystemTicks = Long.parseLong(m.group(15));
            this._processTotalTicks = processUserTicks + processSystemTicks;
            this._processRss = Long.parseLong(m.group(24));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessNumOpenFds(String pid) {
        try {
            String s = "/proc/" + pid + "/fd";
            File f = new File(s);
            String[] arr = f.list();
            if (arr != null) {
                this._processNumOpenFds = arr.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessStatusFile(String pid) {
        try {
            String s = "/proc/" + pid + "/status";
            this._processStatus = this.readFile(new File(s));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void parseProcessStatusFile(String s) {
        if (s == null) {
            return;
        }
        try {
            Pattern p = Pattern.compile("Cpus_allowed:\\s+([A-Fa-f0-9,]+)");
            Matcher m = p.matcher(s);
            boolean b = m.find();
            if (!b) {
                return;
            }
            this._processCpusAllowed = LinuxProcFileReader.numSetBitsHex(m.group(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

