/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.timeseries;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.distribution.NormalDistribution;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public class AstIsax
extends AstPrimitive {
    protected double[][] _domain_hm = null;

    @Override
    public String[] args() {
        return new String[]{"ary", "numWords", "maxCardinality", "optimize_card"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "isax";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        AstRoot n = asts[2];
        AstRoot mc = asts[3];
        boolean optm_card = asts[4].exec(env).getNum() == 1.0;
        for (Vec v : fr.vecs()) {
            if (v.isNumeric()) continue;
            throw new IllegalArgumentException("iSax only applies to numeric columns!");
        }
        int numWords = (int)n.exec(env).getNum();
        int maxCardinality = (int)mc.exec(env).getNum();
        if (numWords < 0) {
            throw new IllegalArgumentException("numWords must be greater than 0!");
        }
        if (maxCardinality < 0) {
            throw new IllegalArgumentException("maxCardinality must be greater than 0!");
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < numWords; ++i) {
            columns.add("c" + i);
        }
        Frame fr2 = ((IsaxTask)new IsaxTask(numWords, maxCardinality).doAll(numWords, (byte)3, fr)).outputFrame(null, columns.toArray(new String[numWords]), null);
        int[] maxCards = new int[numWords];
        if (optm_card) {
            int i;
            for (double[] r : this._domain_hm = new double[numWords][maxCardinality]) {
                Arrays.fill(r, Double.NaN);
            }
            for (i = 0; i < fr2.numCols(); ++i) {
                String[] domains = fr2.vec(i).toCategoricalVec().domain();
                for (int j = 0; j < domains.length; ++j) {
                    this._domain_hm[i][j] = Double.valueOf(domains[j]);
                }
            }
            for (i = 0; i < numWords; ++i) {
                int cnt = 0;
                for (double d : this._domain_hm[i]) {
                    if (Double.isNaN(d)) break;
                    ++cnt;
                }
                maxCards[i] = cnt;
            }
            Frame fr2_reduced = ((IsaxReduceCard)new IsaxReduceCard(this._domain_hm, maxCardinality).doAll(numWords, (byte)3, fr2)).outputFrame(null, columns.toArray(new String[numWords]), null);
            Frame fr3 = ((IsaxStringTask)new IsaxStringTask(maxCards).doAll(1, (byte)2, fr2_reduced)).outputFrame(null, new String[]{"iSax_index"}, null);
            fr2.delete();
            fr3.add(fr2_reduced);
            return new ValFrame(fr3);
        }
        for (int i = 0; i < numWords; ++i) {
            maxCards[i] = maxCardinality;
        }
        Frame fr3 = ((IsaxStringTask)new IsaxStringTask(maxCards).doAll(1, (byte)2, fr2)).outputFrame(null, new String[]{"iSax_index"}, null);
        fr3.add(fr2);
        return new ValFrame(fr3);
    }

    public static class IsaxTask
    extends MRTask<IsaxTask> {
        private int nw;
        private int mc;
        private static NormalDistribution nd = new NormalDistribution();
        private ArrayList<Double> probBoundaries;

        IsaxTask(int numWords, int maxCardinality) {
            this.nw = numWords;
            this.mc = maxCardinality;
            double step = 1.0 / (double)this.mc;
            this.probBoundaries = new ArrayList();
            for (int i = 0; i < this.mc; ++i) {
                this.probBoundaries.add(nd.inverseCumulativeProbability((double)i * step));
            }
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            int step = cs.length / this.nw;
            int chunkSize = cs[0].len();
            int w_i = 0;
            double[] seriesSums = new double[chunkSize];
            double[] seriesCounts = new double[chunkSize];
            double[] seriesSSE = new double[chunkSize];
            double[][] chunkMeans = new double[chunkSize][this.nw];
            for (int i = 0; i < cs.length; i += step) {
                for (int j = 0; j < chunkSize; ++j) {
                    double mySum = 0.0;
                    double myCount = 0.0;
                    for (Chunk c : ArrayUtils.subarray(cs, i, i + step)) {
                        if (c == null) continue;
                        double oldMean = myCount < 1.0 ? 0.0 : mySum / myCount;
                        mySum += c.atd(j);
                        int n = j;
                        seriesSums[n] = seriesSums[n] + c.atd(j);
                        int n2 = j;
                        seriesCounts[n2] = seriesCounts[n2] + 1.0;
                        int n3 = j;
                        seriesSSE[n3] = seriesSSE[n3] + (c.atd(j) - oldMean) * (c.atd(j) - mySum / (myCount += 1.0));
                    }
                    chunkMeans[j][w_i] = mySum / myCount;
                }
                if (++w_i >= this.nw) break;
            }
            for (int w = 0; w < this.nw; ++w) {
                for (int i = 0; i < chunkSize; ++i) {
                    double seriesMean = seriesSums[i] / seriesCounts[i];
                    double seriesStd = Math.sqrt(seriesSSE[i] / (seriesCounts[i] - 1.0));
                    double zscore = (chunkMeans[i][w] - seriesMean) / seriesStd;
                    int p_i = 0;
                    while (this.probBoundaries.get(p_i + 1) < zscore && ++p_i != this.mc - 1) {
                    }
                    nc[w].addNum(p_i, 0);
                }
            }
        }
    }

    public static class IsaxStringTask
    extends MRTask<IsaxStringTask> {
        int[] maxCards;

        IsaxStringTask(int[] mc) {
            this.maxCards = mc;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            int csize = cs[0].len();
            for (int c_i = 0; c_i < csize; ++c_i) {
                StringBuffer sb = new StringBuffer("");
                for (int cs_i = 0; cs_i < cs.length; ++cs_i) {
                    sb.append(cs[cs_i].at8(c_i) + "^" + this.maxCards[cs_i] + "_");
                }
                nc[0].addStr(sb.toString().substring(0, sb.length() - 1));
            }
        }
    }

    public static class IsaxReduceCard
    extends MRTask<IsaxReduceCard> {
        double[][] _domain_hm;
        int maxCardinality;

        IsaxReduceCard(double[][] dm, int mc) {
            this._domain_hm = dm;
            this.maxCardinality = mc;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i = 0; i < cs.length; ++i) {
                boolean ltMaxCardFlag = Double.isNaN(ArrayUtils.sum(this._domain_hm[i]));
                for (int j = 0; j < cs[i].len(); ++j) {
                    int idxOf = ltMaxCardFlag ? Arrays.binarySearch(this._domain_hm[i], (double)((int)cs[i].at8(j))) : (int)cs[i].at8(j);
                    nc[i].addNum(idxOf);
                }
            }
        }
    }
}

