/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.math;

import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;
import water.rapids.vals.ValRow;

public abstract class AstUniOp<T extends AstUniOp<T>>
extends AstBuiltin<T> {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public Val exec(Val ... args) {
        Val val = args[1];
        switch (val.type()) {
            case 1: {
                return new ValNum(this.op(val.getNum()));
            }
            case 5: {
                Frame fr = val.getFrame();
                for (int i = 0; i < fr.numCols(); ++i) {
                    if (fr.vec(i).isNumeric()) continue;
                    throw new IllegalArgumentException("Operator " + this.str() + "() cannot be applied to non-numeric column " + fr.name(i));
                }
                String[] newNames = new String[fr.numCols()];
                for (int i = 0; i < newNames.length; ++i) {
                    newNames[i] = this.str() + "(" + fr.name(i) + ")";
                }
                return new ValFrame(((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk[] cs, NewChunk[] ncs) {
                        for (int col = 0; col < cs.length; ++col) {
                            Chunk c = cs[col];
                            NewChunk nc = ncs[col];
                            for (int i = 0; i < c._len; ++i) {
                                nc.addNum(AstUniOp.this.op(c.atd(i)));
                            }
                        }
                    }
                }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(newNames, null));
            }
            case 6: {
                double[] ds = new double[val.getRow().length];
                for (int i = 0; i < ds.length; ++i) {
                    ds[i] = this.op(val.getRow()[i]);
                }
                String[] names = (String[])((ValRow)val).getNames().clone();
                return new ValRow(ds, names);
            }
        }
        throw H2O.unimpl("unop unimpl: " + val.getClass());
    }

    public abstract double op(double var1);
}

