/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.Freezable;
import water.Iced;
import water.parser.BufferedString;

public interface ParseWriter
extends Freezable {
    public void setColumnNames(String[] var1);

    public void newLine();

    public boolean isString(int var1);

    public void addNumCol(int var1, long var2, int var4);

    public void addNumCol(int var1, double var2);

    public void addInvalidCol(int var1);

    public void addNAs(int var1, int var2);

    public void addStrCol(int var1, BufferedString var2);

    public void rollbackLine();

    public void invalidLine(ParseErr var1);

    public void addError(ParseErr var1);

    public void setIsAllASCII(int var1, boolean var2);

    public boolean hasErrors();

    public ParseErr[] removeErrors();

    public long lineNum();

    public static class UnsupportedTypeOverride
    extends ParseErr {
        public UnsupportedTypeOverride(String fileName, String origType, String targetType, String columnName) {
            super(fileName, "Unsupported type override (" + origType + " -> " + targetType + "). Column " + columnName + " will be parsed as " + origType);
        }
    }

    public static class ParseErr
    extends Iced
    implements Comparable<ParseErr> {
        String _file = "unknown";
        String _err = "unknown";
        long _byteOffset = -1L;
        int _cidx = -1;
        long _lineNum = -1L;
        long _gLineNum = -1L;

        @Override
        public int compareTo(ParseErr o) {
            long res = this._gLineNum - o._gLineNum;
            if (res == 0L) {
                res = this._byteOffset - this._byteOffset;
            }
            if (res == 0L) {
                return this._err.compareTo(o._err);
            }
            return (int)res < 0 ? -1 : 1;
        }

        public ParseErr() {
        }

        public ParseErr(String file, String err) {
            this(err, 0, -1L, -1L);
            this._file = file;
        }

        public ParseErr(String err, int cidx, long lineNum, long byteOff) {
            this._err = err;
            this._cidx = cidx;
            this._lineNum = lineNum;
            this._byteOffset = byteOff;
        }

        public String toString() {
            return "ParseError at file " + this._file + (this._gLineNum == -1L ? "" : " at line " + this._lineNum + " ( destination line " + this._gLineNum + " )") + (this._byteOffset == -1L ? "" : "  at byte offset " + this._byteOffset) + "; error = '" + this._err + "'";
        }
    }
}

